/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.models.readers;

import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.models.FileReader;
import io.quassar.editor.box.models.Workspace;
import io.quassar.editor.box.util.WorkspaceHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class ResourcesReader
implements FileReader {
    private final Workspace workspace;

    public ResourcesReader(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public List<File> files() {
        List<File> list;
        block9: {
            java.io.File resourcesDirectory = new java.io.File(this.workspace.root(), "resources");
            if (!resourcesDirectory.exists()) {
                return Collections.emptyList();
            }
            Stream<Path> paths = Files.walk(resourcesDirectory.toPath(), new FileVisitOption[0]);
            try {
                list = paths.map(p -> WorkspaceHelper.fileOf(p, this.workspace)).toList();
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.error((Throwable)e);
                    return Collections.emptyList();
                }
            }
            paths.close();
        }
        return list;
    }

    @Override
    public boolean exists(String name, File parent) {
        return new java.io.File(this.location(parent), name).exists();
    }

    @Override
    public File get(String uri) {
        return WorkspaceHelper.fileOf(new java.io.File(this.workspace.root(), uri), this.workspace);
    }

    @Override
    public InputStream content(String uri) {
        try {
            return new FileInputStream(new java.io.File(this.workspace.root(), uri));
        }
        catch (FileNotFoundException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private List<File> filter(List<File> files) {
        return files.stream().filter(File::isResource).toList();
    }

    private java.io.File location(File file) {
        if (file == null) {
            return this.workspace.root();
        }
        return new java.io.File(this.workspace.root(), file.uri());
    }
}

