/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.models.readers;

import io.intino.alexandria.logger.Logger;
import io.intino.ls.IntinoLanguageServer;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.models.FileReader;
import io.quassar.editor.box.models.Workspace;
import io.quassar.editor.box.util.WorkspaceHelper;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;

public class ModelReader
implements FileReader {
    private final Workspace workspace;
    private final LanguageServer server;

    public ModelReader(Workspace workspace, LanguageServer server) {
        this.workspace = workspace;
        this.server = server;
    }

    @Override
    public List<File> files() {
        try {
            if (this.server == null) {
                return Collections.emptyList();
            }
            Either symbols = (Either)this.server.getWorkspaceService().symbol(new WorkspaceSymbolParams()).get();
            return this.filter(WorkspaceHelper.filesOf((List)symbols.getRight()));
        }
        catch (InterruptedException | ExecutionException e) {
            Logger.error((Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public boolean exists(String name, File parent) {
        return new java.io.File(this.location(parent), name).exists();
    }

    @Override
    public File get(String uri) {
        return WorkspaceHelper.fileOf(new java.io.File(this.workspace.root(), uri), this.workspace);
    }

    @Override
    public InputStream content(String uri) {
        InputStream inputStream;
        block9: {
            if (this.server == null) {
                return null;
            }
            InputStream content = ((IntinoLanguageServer)this.server).getWorkspaceService().content(URI.create(uri));
            try {
                inputStream = content;
                if (content == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ignored) {
                    return null;
                }
            }
            content.close();
        }
        return inputStream;
    }

    private List<File> filter(List<File> files) {
        return files.stream().filter((? super T f) -> f.name().contains(".tara") || f.isDirectory() && !f.isResource()).toList();
    }

    private java.io.File location(File file) {
        if (file == null) {
            return this.workspace.root();
        }
        return new java.io.File(this.workspace.root(), file.uri());
    }
}

