/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.models;

import io.quassar.archetype.Archetype;
import io.quassar.editor.box.util.WorkspaceHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.Model;
import java.io.File;
import java.net.URI;

public class Workspace {
    private final Model model;
    private final String release;
    private final Language language;
    private final Archetype archetype;

    public Workspace(Model model, String release, Language language, Archetype archetype) {
        this.model = model;
        this.release = release;
        this.language = language;
        this.archetype = archetype;
    }

    public File root() {
        URI workspace = WorkspaceHelper.workspace(this.model, this.release, this.archetype);
        return workspace != null ? new File(workspace) : null;
    }

    public Language language() {
        return this.language;
    }

    public Model model() {
        return this.model;
    }

    public String release() {
        return this.release;
    }

    public Workspace clone(Model destinyModel) {
        return new Workspace(destinyModel, this.release, this.language, this.archetype);
    }
}

