/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box;

import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.util.DirUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;

public class SubjectGenerator {
    private final EditorBox box;

    public SubjectGenerator(EditorBox box) {
        this.box = box;
    }

    public void generate() {
        Logger.info((String)"Generating default subjects");
        this.createIndex();
        DirUtils.copyDir("datamart/default-languages", this.box.archetype().languages().root());
        DirUtils.copyDir("datamart/default-models", this.box.archetype().models().root());
        Logger.info((String)"Default subjects GENERATED!");
    }

    private void createIndex() {
        try (InputStream stream = SubjectGenerator.class.getResourceAsStream("/datamart/index.triples");){
            if (stream == null) {
                return;
            }
            Files.copy(stream, this.box.archetype().index().toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }
}

