/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.AlexandriaUiServer;
import io.intino.alexandria.ui.AlexandriaWebSocket;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.auth.Space;
import io.intino.amidas.accessor.alexandria.core.AmidasOauthAccessor;
import io.intino.builderservice.QuassarBuilderServiceAccessor;
import io.intino.builderservice.schemas.RegisterBuilder;
import io.quassar.archetype.Archetype;
import io.quassar.editor.box.AbstractBox;
import io.quassar.editor.box.EditorConfiguration;
import io.quassar.editor.box.SubjectGenerator;
import io.quassar.editor.box.commands.Commands;
import io.quassar.editor.box.commands.CommandsFactory;
import io.quassar.editor.box.languages.LanguageLoader;
import io.quassar.editor.box.languages.LanguageManager;
import io.quassar.editor.box.languages.LanguageServerManager;
import io.quassar.editor.box.languages.LanguageServerWebSocketHandler;
import io.quassar.editor.box.languages.artifactories.LocalLanguageArtifactory;
import io.quassar.editor.box.models.ModelManager;
import io.quassar.editor.box.projects.ProjectManager;
import io.quassar.editor.box.users.UserManager;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.Model;
import io.quassar.editor.model.Utilities;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.lsp4j.services.LanguageServer;
import systems.intino.datamarts.subjectstore.SubjectStore;

public class EditorBox
extends AbstractBox {
    private final Archetype archetype;
    private SubjectStore subjectStore;
    private AmidasOauthAccessor authService;
    private LanguageLoader languageLoader;
    private LanguageManager languageManager;
    private ModelManager modelManager;
    private UserManager userManager;
    private ProjectManager projectManager;
    private CommandsFactory commandsFactory;
    private LanguageServerManager serverManager;
    private QuassarBuilderServiceAccessor builderAccessor;
    private Utilities utilities;

    public EditorBox(String[] args) {
        this(new EditorConfiguration(args));
    }

    public EditorBox(EditorConfiguration configuration) {
        super(configuration);
        this.archetype = new Archetype(configuration.home());
    }

    @Override
    public Box put(Object o) {
        super.put(o);
        return this;
    }

    @Override
    protected void beforeSetupEditorElementsUi(AlexandriaUiServer server) {
        server.registerWs("/dsl/tara", (AlexandriaWebSocket)new LanguageServerWebSocketHandler(this::serverFor));
    }

    @Override
    public void beforeStart() {
        boolean exists = this.archetype.index().exists();
        if (!exists) {
            new SubjectGenerator(this).generate();
        }
        this.subjectStore = this.createSubjectStore();
        this.utilities = new Utilities(this.archetype.configuration().editor().utilities());
        this.commandsFactory = new CommandsFactory(this);
        this.languageLoader = new LanguageLoader(new LocalLanguageArtifactory(this.archetype, this::modelWithLanguage));
        this.languageManager = new LanguageManager(this.archetype, this.subjectStore);
        this.serverManager = new LanguageServerManager(this.languageLoader, this::workSpaceOf);
        this.modelManager = new ModelManager(this.archetype, this.subjectStore, l -> this.languageManager.get((GavCoordinates)l), this.serverManager);
        this.userManager = new UserManager(this.archetype, this.subjectStore);
        this.projectManager = new ProjectManager(this.archetype);
        this.builderAccessor = new QuassarBuilderServiceAccessor(EditorBox.url(this.configuration.builderServiceUrl()));
        this.setupServiceBuilder();
    }

    private SubjectStore createSubjectStore() {
        try {
            return new SubjectStore(this.archetype.index());
        }
        catch (IOException e) {
            return null;
        }
    }

    private Model modelWithLanguage(String id) {
        String metamodel = this.languageManager.get(Language.nameFrom(id)).metamodel();
        return metamodel != null ? this.modelManager.get(metamodel) : null;
    }

    private URI workSpaceOf(Model model, String version) {
        return this.modelManager.workspace(model, version).root().toURI();
    }

    @Override
    public void afterStart() {
    }

    @Override
    public void beforeStop() {
        try {
            this.subjectStore.seal();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    @Override
    public void afterStop() {
    }

    public Utilities utilities() {
        return this.utilities;
    }

    public Archetype archetype() {
        return this.archetype;
    }

    public LanguageManager languageManager() {
        return this.languageManager;
    }

    public ModelManager modelManager() {
        return this.modelManager;
    }

    public UserManager userManager() {
        return this.userManager;
    }

    public ProjectManager projectManager() {
        return this.projectManager;
    }

    public QuassarBuilderServiceAccessor builderAccessor() {
        return this.builderAccessor;
    }

    public AmidasOauthAccessor authService() {
        return this.authService;
    }

    @Override
    protected AuthService authService(URL authServiceUrl) {
        if (this.authService == null) {
            this.authService = authServiceUrl != null ? new AmidasOauthAccessor(new Space(EditorBox.url(this.configuration().url())).name("quasar-editor"), authServiceUrl) : null;
        }
        return this.authService;
    }

    public <T extends Commands> T commands(Class<T> clazz) {
        return this.commandsFactory.commands(clazz);
    }

    public boolean isLocalRunning() {
        File[] files = this.archetype.configuration().root().listFiles();
        return files == null || Arrays.stream(files).filter(f -> !f.getName().startsWith(".")).allMatch(File::isDirectory);
    }

    private LanguageServer serverFor(Session session) {
        try {
            Map parameterMap = session.getUpgradeRequest().getParameterMap();
            Model model = this.modelManager.get((String)((List)parameterMap.get("model")).getFirst());
            return this.serverManager.get(model, (String)((List)parameterMap.get("model-release")).getFirst());
        }
        catch (IOException | URISyntaxException | GitAPIException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private void setupServiceBuilder() {
        try {
            this.builderAccessor.postBuilders(new RegisterBuilder().imageURL(this.configuration().quassarBuilder()));
        }
        catch (InternalServerError e) {
            Logger.error((Throwable)e);
        }
    }
}

