/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractProjectModuleViewer;
import io.quassar.editor.box.ui.displays.templates.ProjectModuleEntryViewer;
import io.quassar.editor.model.Model;
import java.util.List;
import java.util.function.Consumer;

public class ProjectModuleViewer
extends AbstractProjectModuleViewer<EditorBox> {
    private Model model;
    private String module;
    private boolean showTitle = true;
    private Consumer<Model> selectListener;

    public ProjectModuleViewer(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    public void module(String module) {
        this.module = module;
    }

    public void showTitle(boolean value) {
        this.showTitle = value;
    }

    public void onSelect(Consumer<Model> listener) {
        this.selectListener = listener;
    }

    public void refresh() {
        super.refresh();
        this.moduleName.visible(this.showTitle);
        if (this.showTitle) {
            this.moduleName.value(this.module);
        }
        List<Model> models = ((EditorBox)this.box()).modelManager().models(this.model.project(), this.module, this.username());
        this.entries.clear();
        models.forEach(m -> this.fill((Model)m, (ProjectModuleEntryViewer)this.entries.add()));
    }

    private void fill(Model model, ProjectModuleEntryViewer display) {
        display.model(model);
        display.selected(model.id().equals(this.model.id()));
        display.onSelect((Boolean e) -> this.selectListener.accept(model));
        display.refresh();
    }
}

