/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.model;

import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import java.util.Objects;

public record GavCoordinates(String groupId, String artifactId, String version) {
    public static GavCoordinates fromString(String content) {
        String[] split = content.split(":");
        return new GavCoordinates(split[0], split[1], split[2]);
    }

    public static GavCoordinates fromString(Language language, LanguageRelease release) {
        return new GavCoordinates(language.group(), language.name(), release.version());
    }

    public boolean isEmpty() {
        return this.artifactId == null || this.artifactId.isEmpty();
    }

    public String languageId() {
        return Language.key(this.groupId, this.artifactId);
    }

    public boolean matches(Language language) {
        return language.group().equals(this.groupId) && language.name().equals(this.artifactId);
    }

    @Override
    public String toString() {
        String result = this.groupId != null && !this.groupId.isEmpty() ? this.groupId : "";
        return result + (!result.isEmpty() ? ":" : "") + this.artifactId + ":" + this.version;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GavCoordinates that = (GavCoordinates)obj;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version);
    }
}

