/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.Collection;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractModelsDialog;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.Language;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class ModelsDialog
extends AbstractModelsDialog<EditorBox> {
    private Consumer<Boolean> addModelListener;
    private Language language;
    private Function<Language, Long> countItemsProvider = null;
    private Collection<?, ?> collection;

    public ModelsDialog(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void countItemsProvider(Function<Language, Long> provider) {
        this.countItemsProvider = provider;
    }

    @Override
    public void init() {
        super.init();
        this.addModelTrigger.onExecute(e -> this.notifyAddModel());
        this.mostRecentLink.onExecute(e -> this.updateSorting("most recent"));
        this.lastModifiedLink.onExecute(e -> this.updateSorting("last modified"));
    }

    public void refresh() {
        super.refresh();
        this.refreshSorting("most recent");
        this.searchBox.condition(null);
        this.addModelTrigger.visible(this.addModelListener != null && PermissionsHelper.canAddModel(this.language, this.session(), (EditorBox)this.box()));
        this.catalogOperations.visible(this.countItemsProvider.apply(this.language) > DisplayHelper.MinItemsCount);
    }

    public void onAddModel(Consumer<Boolean> listener) {
        this.addModelListener = listener;
    }

    public void bindTo(Collection<?, ?> collection) {
        this.collection = collection;
        this.searchBox.bindTo(new Collection[]{collection});
    }

    private void notifyAddModel() {
        this.addModelListener.accept(true);
    }

    private void updateSorting(String sorting) {
        this.collection.sortings(List.of(sorting));
        this.refreshSorting(sorting);
    }

    private void refreshSorting(String sorting) {
        this.mostRecentLink.visible(!sorting.equals("most recent"));
        this.mostRecentText.visible(sorting.equals("most recent"));
        this.lastModifiedLink.visible(!sorting.equals("last modified"));
        this.lastModifiedText.visible(sorting.equals("last modified"));
    }
}

