/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractCollaboratorsTemplate;
import io.quassar.editor.box.ui.displays.templates.CollaboratorItemTemplate;
import io.quassar.editor.model.Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class CollaboratorsTemplate
extends AbstractCollaboratorsTemplate<EditorBox> {
    private Model model;
    private Consumer<List<String>> changeListener;
    private Set<String> collaboratorSet = new HashSet<String>();

    public CollaboratorsTemplate(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
        this.collaboratorSet = new HashSet<String>(model.collaborators());
    }

    public void onChange(Consumer<List<String>> listener) {
        this.changeListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.invite.onExecute(e -> this.invitePeople());
    }

    public void refresh() {
        super.refresh();
        this.peopleField.value(null);
        this.ownerField.value(this.model.owner());
        this.collaborators.clear();
        this.collaboratorSet.forEach(u -> this.fill((String)u, (CollaboratorItemTemplate)this.collaborators.add()));
    }

    private void fill(String user, CollaboratorItemTemplate display) {
        display.user(user);
        display.onRemove(this::removeUser);
        display.refresh();
    }

    private void removeUser(String user) {
        this.collaboratorSet.remove(user);
        this.notifyChange();
        this.refresh();
    }

    private void invitePeople() {
        List<String> people = Arrays.stream(this.peopleField.value().split(";?\\n")).map(String::trim).filter(s -> !s.isEmpty()).toList();
        this.collaboratorSet.addAll(people);
        this.peopleField.value(null);
        this.notifyChange();
        this.refresh();
    }

    private void notifyChange() {
        this.changeListener.accept(new ArrayList<String>(this.collaboratorSet));
    }
}

