/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.datasources;

import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.Group;
import io.intino.alexandria.ui.model.datasource.PageDatasource;
import io.intino.alexandria.ui.services.push.UISession;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.models.ModelManager;
import io.quassar.editor.box.ui.types.LanguageTab;
import io.quassar.editor.box.util.DatasourceHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class ModelsDatasource
extends PageDatasource<Model> {
    protected final EditorBox box;
    protected final UISession session;
    private final Language language;
    private final LanguageTab tab;
    private final LanguageRelease release;
    private String condition;
    private List<Filter> filters;
    private Sorting sorting;

    public ModelsDatasource(EditorBox box, UISession session, Language language, LanguageRelease release, LanguageTab tab) {
        this.box = box;
        this.session = session;
        this.language = language;
        this.release = release;
        this.tab = tab;
    }

    public void sort(Sorting sorting) {
        this.sorting = sorting;
    }

    public long itemCount() {
        return this.itemCount(this.condition, this.filters);
    }

    public List<Model> items(int start, int count, String condition, List<Filter> filters, List<String> sortings) {
        this.saveParameters(condition, filters);
        List<Model> result = this.sort(this.load(condition, filters), sortings);
        int from = Math.min(start, result.size());
        int end = Math.min(start + count, result.size());
        return result.subList(from, end);
    }

    public long itemCount(String condition, List<Filter> filters) {
        return this.load(condition, filters).size();
    }

    public List<Group> groups(String key) {
        if (key.equalsIgnoreCase("owner")) {
            return this.load().stream().map(Model::owner).distinct().map(o -> new Group().name(o).label(o)).toList();
        }
        return new ArrayList<Group>();
    }

    protected List<Model> load() {
        ModelManager manager = this.box.modelManager();
        return this.tab == LanguageTab.Examples ? manager.exampleModels(this.language, this.release) : manager.models(this.language, this.username());
    }

    protected String username() {
        return this.session.user() != null ? this.session.user().username() : "anonymous";
    }

    private List<Model> load(String condition, List<Filter> filters) {
        List<Model> models = this.load();
        models = this.filterOwner(models, filters);
        models = this.filterCondition(models, condition);
        return models;
    }

    private List<Model> filterOwner(List<Model> models, List<Filter> filters) {
        List<String> owners = DatasourceHelper.categories("owner", filters);
        if (owners.isEmpty()) {
            return models;
        }
        return models.stream().filter(l -> owners.contains(l.owner())).collect(Collectors.toList());
    }

    private List<Model> filterCondition(List<Model> models, String condition) {
        if (condition == null || condition.isEmpty()) {
            return models;
        }
        String[] conditions = condition.toLowerCase().split(" ");
        return models.stream().filter(m -> DatasourceHelper.matches(m.name(), conditions) || DatasourceHelper.matches(m.title(), conditions) || DatasourceHelper.matches(m.qualifiedTitle(), conditions) || DatasourceHelper.matches(m.description(), conditions) || DatasourceHelper.matches(m.project(), conditions) || DatasourceHelper.matches(m.module(), conditions) || DatasourceHelper.matches(m.owner(), conditions) || DatasourceHelper.matches(m.language().toString(), conditions)).collect(Collectors.toList());
    }

    private List<Model> sort(List<Model> models, List<String> sortings) {
        if (sortings.contains("last modified")) {
            return models.stream().sorted(this.lastModifiedComparator()).toList();
        }
        return models.stream().sorted(Comparator.comparing(Model::createDate)).toList();
    }

    private Comparator<? super Model> lastModifiedComparator() {
        return (o1, o2) -> {
            Instant instant1 = o1.updateDate();
            Instant instant2 = o2.updateDate();
            if (instant1 == null || instant2 == null) {
                return -1;
            }
            return instant2.compareTo(instant1);
        };
    }

    private void saveParameters(String condition, List<Filter> filters) {
        this.condition = condition;
        this.filters = filters;
    }

    public static enum Sorting {
        MostUsed,
        MostRecent;

    }
}

