/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands.language;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.Model;
import java.io.File;
import java.util.UUID;

public class CreateLanguageCommand
extends Command<Language> {
    public String id;
    public Model metamodel;
    public Language.Level level;
    public File logo;

    public CreateLanguageCommand(EditorBox box) {
        super(box);
    }

    @Override
    public Language execute() {
        Language language = this.box.languageManager().create(Language.groupFrom(this.id), Language.nameFrom(this.id), this.metamodel, this.level, "", "");
        this.metamodel.title(Language.nameFrom(this.id).toUpperCase());
        this.box.languageManager().saveLogo(language, this.logo(language));
        return language;
    }

    private File logo(Language language) {
        if (this.logo != null) {
            return this.logo;
        }
        File file = new File(this.box.archetype().tmp().root(), UUID.randomUUID().toString());
        LanguageHelper.generateLogo(language.name(), file);
        return file;
    }
}

