/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.alexandria.ui.displays.events.AddCollectionItemEvent;
import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.intino.alexandria.ui.model.Datasource;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.models.ModelContainer;
import io.quassar.editor.box.ui.datasources.ModelsDatasource;
import io.quassar.editor.box.ui.displays.items.ModelItem;
import io.quassar.editor.box.ui.displays.templates.AbstractModelsTemplate;
import io.quassar.editor.box.ui.displays.templates.ModelsDialog;
import io.quassar.editor.box.ui.types.LanguageTab;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import java.util.function.Function;

public class ModelsTemplate
extends AbstractModelsTemplate<EditorBox> {
    private Language language;
    private LanguageRelease release;
    private LanguageTab tab;
    private Function<Boolean, Model> createModelListener;
    private Mode mode = Mode.Normal;
    private ModelsDialog dialog;
    private Model selectedModel;

    public ModelsTemplate(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void release(LanguageRelease release) {
        this.release = release;
    }

    public void tab(LanguageTab tab) {
        this.tab = tab;
    }

    public void bindTo(ModelsDialog dialog) {
        this.dialog = dialog;
        dialog.onAddModel(this.mode != Mode.Embedded ? e -> this.notifyCreateModel() : null);
        dialog.bindTo((Collection<?, ?>)this.modelList);
    }

    public void mode(Mode mode) {
        this.mode = mode;
    }

    public void onCreateModel(Function<Boolean, Model> listener) {
        this.createModelListener = listener;
    }

    public void refresh(Model model) {
        int index = this.modelList.findItem(i -> i instanceof Model && ((Model)i).id().equals(model.id()));
        if (index == -1) {
            return;
        }
        this.modelList.refresh(index, model);
    }

    @Override
    public void init() {
        super.init();
        this.modelList.onAddItem(this::refresh);
        this.backExamples.onExecute(e -> this.openBody());
    }

    public void refresh() {
        super.refresh();
        LanguageRelease release = this.release != null ? this.language.release(this.release.version()) : null;
        ModelsDatasource source = new ModelsDatasource((EditorBox)this.box(), this.session(), this.language, release, this.tab);
        this.refreshList(source);
        this.refreshDialog(source);
    }

    private void refreshList(ModelsDatasource source) {
        this.modelList.source((Datasource)source);
        this.modelList.reload();
    }

    private void refreshDialog(ModelsDatasource source) {
        if (this.dialog == null) {
            return;
        }
        this.dialog.language(this.language);
        this.dialog.countItemsProvider(l -> source.itemCount());
        this.dialog.refresh();
    }

    private void refresh(AddCollectionItemEvent event) {
        this.refresh((Model)event.item(), (ModelItem)event.component());
    }

    private void refresh(Model model, ModelItem display) {
        this.refreshLabel(model, display);
        this.refreshSiteLabel(model, display);
        this.refreshEmbeddedLabel(model, display);
        display.description.value(model.description() != null && !model.description().equals(this.translate("(no description)")) ? model.description() : null);
        display.language.visible(true);
        if (display.language.isVisible()) {
            display.language.value(model.language().artifactId() + " " + model.language().version());
        }
        display.createDate.value(model.createDate());
        display.updateDate.value(model.updateDate());
        display.owner.visible(model.owner() != null && !model.owner().equals(this.username()));
        if (display.owner.isVisible()) {
            display.owner.value(model.owner());
        }
    }

    private void refreshLabel(Model model, ModelItem display) {
        display.label.visible(this.mode == Mode.Normal);
        if (!display.label.isVisible()) {
            return;
        }
        display.label.title(ModelHelper.label(model, this.language(), (EditorBox)this.box()));
        display.label.address(path -> PathHelper.modelPath(path, model));
    }

    private void refreshSiteLabel(Model model, ModelItem display) {
        display.siteLabel.visible(this.mode == Mode.Forge);
        if (!display.siteLabel.isVisible()) {
            return;
        }
        display.siteLabel.title(ModelHelper.label(model, this.language(), (EditorBox)this.box()));
        display.siteLabel.site(PathHelper.modelUrlFromForge(model, this.session()));
    }

    private void refreshEmbeddedLabel(Model model, ModelItem display) {
        display.embeddedLabel.visible(this.mode == Mode.Embedded);
        if (!display.embeddedLabel.isVisible()) {
            return;
        }
        display.embeddedLabel.title(ModelHelper.label(model, this.language(), (EditorBox)this.box()));
        display.embeddedLabel.onExecute(e -> this.openModel(model));
    }

    private void notifyCreateModel() {
        if (this.createModelListener == null) {
            return;
        }
        Model model = this.createModelListener.apply(true);
        if (this.mode == Mode.Normal) {
            ((TemplateNotifier)this.notifier).dispatch(PathHelper.startingModelPath(model));
        } else {
            this.modelTrigger.site(PathHelper.modelUrlFromForge(model, this.session()));
            this.modelTrigger.launch();
        }
    }

    private void openBody() {
        this.embeddedModelBlock.hide();
        this.body.show();
    }

    private void openModel(Model model) {
        ModelContainer modelContainer = ((EditorBox)this.box()).modelManager().modelContainer(model, "draft");
        if (modelContainer == null) {
            return;
        }
        this.body.hide();
        this.embeddedModelBlock.show();
        this.selectedModel = model;
        this.modelTitle.value(ModelHelper.label(model, this.language(), (EditorBox)this.box()));
        this.embeddedModelPreview.model(model, "draft");
        this.embeddedModelPreview.reset();
    }

    public static enum Mode {
        Normal,
        Embedded,
        Forge;

    }
}

