/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.actions;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.exceptions.Forbidden;
import io.intino.alexandria.exceptions.NotFound;
import io.intino.alexandria.http.server.AlexandriaHttpContext;
import io.intino.alexandria.rest.RequestErrorHandler;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.util.ArtifactoryHelper;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import java.io.File;

public class GetArtifactoryFileAction
implements RequestErrorHandler {
    public EditorBox box;
    public AlexandriaHttpContext context;

    public Resource execute() throws Forbidden, NotFound {
        GavCoordinates coordinates = ArtifactoryHelper.parse(this.pathInfo());
        if (coordinates == null) {
            throw new Forbidden("Repository file not found");
        }
        Language language = this.locateLanguage(coordinates);
        if (language == null) {
            throw new NotFound("Repository file not found");
        }
        LanguageRelease release = language.release(coordinates.version());
        if (release == null) {
            throw new NotFound("Repository file not found");
        }
        String extension = this.fileExtension();
        boolean isJar = this.pathInfo().contains(".jar");
        boolean isManifest = this.pathInfo().contains(".pom");
        boolean isDigest = extension.equals(".sha1");
        if (coordinates.artifactId().equals("graph")) {
            return isJar ? new Resource(this.box.languageManager().loadGraph(language, release)) : GetArtifactoryFileAction.emptyFile();
        }
        boolean isDsl = coordinates.artifactId().equals(language.name());
        return isDsl ? this.loadDsl(language, release, isManifest, isDigest) : this.loadParser(language, release, coordinates.artifactId(), isManifest, isDigest);
    }

    private Language locateLanguage(GavCoordinates coordinates) {
        Language language = this.box.languageManager().get(coordinates);
        if (language == null) {
            language = this.box.languageManager().get(Language.nameFrom(coordinates.groupId()));
        }
        return language;
    }

    private Resource loadDsl(Language language, LanguageRelease release, boolean isManifest, boolean isDigest) {
        if (isManifest) {
            File result = isDigest ? this.box.languageManager().loadDslManifestDigest(language, release) : this.box.languageManager().loadDslManifest(language, release);
            return result != null ? new Resource(result) : GetArtifactoryFileAction.emptyFile();
        }
        return new Resource(isDigest ? this.box.languageManager().loadDslDigest(language, release) : this.box.languageManager().loadDsl(language, release));
    }

    private Resource loadParser(Language language, LanguageRelease release, String artifactId, boolean isManifest, boolean isDigest) {
        String file = ArtifactoryHelper.parserNameFor(artifactId);
        if (isManifest) {
            return new Resource(isDigest ? this.box.languageManager().loadParserManifestDigest(language, release, file) : this.box.languageManager().loadParserManifest(language, release, file));
        }
        return new Resource(isDigest ? this.box.languageManager().loadParserDigest(language, release, file) : this.box.languageManager().loadParser(language, release, file));
    }

    private String fileExtension() {
        return this.pathInfo().substring(this.pathInfo().lastIndexOf("."));
    }

    private String pathInfo() {
        String pathInfo = (String)this.context.get((Object)"pathInfo");
        String defaultPath = "/artifacts/releases";
        return pathInfo.substring(pathInfo.indexOf(defaultPath) + defaultPath.length() + 1);
    }

    public void onMalformedRequest(Throwable e) throws AlexandriaException {
        throw new BadRequest("Malformed request");
    }

    private static Resource emptyFile() {
        return new Resource("pom.xml", new byte[0]);
    }
}

