/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.ui.displays.templates.AbstractModelLanguageToolbar;
import io.quassar.editor.box.ui.types.LanguageTab;
import io.quassar.editor.box.ui.types.ModelView;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.FilePosition;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.Model;

public class ModelLanguageToolbar
extends AbstractModelLanguageToolbar<EditorBox> {
    private Model model;
    private String release;
    private ModelView view;
    private LanguageTab tab;
    private File file;
    private FilePosition filePosition;

    public ModelLanguageToolbar(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    public void release(String release) {
        this.release = release;
    }

    public void view(ModelView view) {
        this.view = view;
    }

    public void tab(LanguageTab tab) {
        this.tab = tab;
    }

    public void file(File file) {
        this.file = file;
    }

    public void filePosition(FilePosition position) {
        this.filePosition = position;
    }

    public void refresh() {
        super.refresh();
        Language language = ((EditorBox)this.box()).languageManager().get(this.model.language());
        this.refreshAbout(language);
        this.refreshExamples(language);
        this.refreshHelp(language);
        this.refreshLogo(language);
    }

    private void refreshAbout(Language language) {
        this.aboutText.visible(this.tab == LanguageTab.About);
        this.aboutLink.visible(this.tab != LanguageTab.About);
        if (this.aboutText.isVisible()) {
            this.aboutText.value(this.model.language().artifactId());
        }
        if (this.aboutLink.isVisible()) {
            this.aboutLink.address(a -> PathHelper.modelPath(a, this.model, this.release, LanguageTab.About, this.view, this.file, this.filePosition));
            this.aboutLink.title(this.model.language().artifactId());
        }
    }

    private void refreshHelp(Language language) {
        this.helpText.visible(this.tab == LanguageTab.Help);
        this.helpLink.visible(this.tab != LanguageTab.Help);
        if (this.helpLink.isVisible()) {
            this.helpLink.address(a -> PathHelper.modelPath(a, this.model, this.release, LanguageTab.Help, this.view, this.file, this.filePosition));
        }
    }

    private void refreshExamples(Language language) {
        boolean hasExamples = LanguageHelper.hasExamples(language);
        this.examplesText.visible(hasExamples && this.tab == LanguageTab.Examples);
        this.examplesLink.visible(hasExamples && this.tab != LanguageTab.Examples);
        if (this.examplesLink.isVisible()) {
            this.examplesLink.address(a -> PathHelper.modelPath(a, this.model, this.release, LanguageTab.Examples, this.view, this.file, this.filePosition));
        }
    }

    private void refreshLogo(Language language) {
        this.languageLogo.value(LanguageHelper.logo(language, (EditorBox)this.box()));
    }
}

