/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.LanguageCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractCreateLanguageEditor;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.Model;
import java.util.function.Consumer;

public class CreateLanguageEditor
extends AbstractCreateLanguageEditor<EditorBox> {
    private Model metamodel;
    private Consumer<Language> createListener;
    private String release;

    public CreateLanguageEditor(EditorBox box) {
        super(box);
    }

    public void model(Model metamodel) {
        this.metamodel = metamodel;
    }

    public void release(String release) {
        this.release = release;
    }

    public void onCreate(Consumer<Language> listener) {
        this.createListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.editorStamp.onCheckId(valid -> this.create.readonly(valid == false));
        this.editorStamp.onChangeId(valid -> this.createLanguage());
        this.create.onExecute(e -> this.createLanguage());
    }

    public void refresh() {
        super.refresh();
        this.metamodelTitle.value("Create DSL");
        this.editorStamp.focus();
    }

    private void createLanguage() {
        if (!this.editorStamp.check()) {
            return;
        }
        this.create.readonly(true);
        this.notifyUser("Creating language...", UserMessage.Type.Loading);
        Language language = ((EditorBox)this.box()).commands(LanguageCommands.class).create(this.editorStamp.languageId(), this.metamodel, Language.Level.L1, this.editorStamp.logo(), this.username());
        this.hideUserNotification();
        this.create.readonly(false);
        this.createListener.accept(language);
    }
}

