/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.model;

import io.quassar.editor.box.util.VersionNumberComparator;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.SubjectWrapper;
import io.quassar.editor.model.Visibility;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import systems.intino.datamarts.subjectstore.model.Subject;

public class Language
extends SubjectWrapper {
    public static final String FileExtension = ".tara";
    public static final String FoundationalGroup = "tara.dsl";
    public static final String QuassarGroup = "io.quassar";
    public static final String Metta = "metta";

    public static String key(String group, String name) {
        if (group == null || group.isEmpty() || group.equalsIgnoreCase(QuassarGroup) || group.equalsIgnoreCase(FoundationalGroup)) {
            return name;
        }
        return group + "." + name;
    }

    public static String groupFrom(String id) {
        return id.contains(".") ? id.substring(0, id.indexOf(".")) : "";
    }

    public static String nameFrom(String id) {
        return id.contains(".") ? id.substring(id.lastIndexOf(".") + 1) : id;
    }

    public String id() {
        return this.subject.name();
    }

    public String key() {
        return Language.key(this.group(), this.name());
    }

    public Language(Subject subject) {
        super(subject);
    }

    public String group() {
        String group = this.getOrEmpty("group");
        return !group.isEmpty() ? group : QuassarGroup;
    }

    public void group(String group) {
        this.set("group", group);
    }

    public boolean isFoundational() {
        String group = this.group();
        return group != null && group.equals(FoundationalGroup);
    }

    public String name() {
        return this.getOrEmpty("name");
    }

    public void name(String value) {
        this.set("name", value);
    }

    public String metamodel() {
        return this.get("metamodel");
    }

    public void metamodel(String value) {
        this.set("metamodel", value);
    }

    public Level level() {
        return Level.valueOf(this.get("level"));
    }

    public void level(Level value) {
        this.set("level", value.name());
    }

    public GavCoordinates parent() {
        return new GavCoordinates(this.getOrEmpty("parent-group"), this.getOrEmpty("parent-name"), this.getOrEmpty("parent-version"));
    }

    public void parent(GavCoordinates value) {
        this.set("parent-group", value.groupId());
        this.set("parent-name", value.artifactId());
        this.set("parent-version", value.version());
    }

    public String title() {
        return this.get("title");
    }

    public void title(String value) {
        this.set("title", value);
    }

    public String description() {
        return this.getOrEmpty("description");
    }

    public void description(String value) {
        this.set("description", value);
    }

    public List<String> grantAccessList() {
        return this.getList("access");
    }

    public void grantAccessList(List<String> values) {
        this.putList("access", values);
    }

    public String citation() {
        return this.getOrEmpty("citation");
    }

    public void citation(String citation) {
        this.set("citation", citation);
    }

    public String citationLink() {
        return this.getOrEmpty("citation-link");
    }

    public void citationLink(String value) {
        this.set("citation-link", value);
    }

    public String license() {
        return this.getOrEmpty("license");
    }

    public void license(String license) {
        this.set("license", license);
    }

    public List<String> tags() {
        return this.getList("tag");
    }

    public void tags(List<String> tagList) {
        this.putList("tag", tagList);
    }

    public List<LanguageRelease> releases() {
        Stream<Subject> result = this.subject.children().collect().stream().filter(s -> s.is("release"));
        return result.map(this::releaseOf).toList();
    }

    public LanguageRelease release(String version) {
        return this.releases().stream().filter(r -> r.version().equals(version)).findFirst().orElse(null);
    }

    public LanguageRelease lastRelease() {
        List<LanguageRelease> releases = this.releases();
        return !releases.isEmpty() ? (LanguageRelease)releases.stream().sorted((o1, o2) -> VersionNumberComparator.getInstance().compare(o2.version(), o1.version())).toList().getFirst() : null;
    }

    public boolean isPublic() {
        return !this.isPrivate();
    }

    public boolean isPrivate() {
        return this.visibility() == Visibility.Private;
    }

    public void isPrivate(boolean value) {
        this.visibility(value ? Visibility.Private : Visibility.Public);
    }

    public Visibility visibility() {
        return this.get("visibility") == null ? Visibility.Private : Visibility.valueOf(this.get("visibility"));
    }

    public void visibility(Visibility value) {
        this.set("visibility", value.name());
    }

    public Instant createDate() {
        return Instant.parse(this.get("create-date"));
    }

    public void createDate(Instant createDate) {
        this.set("create-date", createDate.toString());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Language language = (Language)o;
        return Objects.equals(this.key(), language.key());
    }

    public int hashCode() {
        return Objects.hashCode(this.key());
    }

    private LanguageRelease releaseOf(Subject subject) {
        return new LanguageRelease(subject);
    }

    public static enum Level {
        L1,
        L2,
        L3;

    }
}

