/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.actions;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.Forbidden;
import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.actions.QuassarAction;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.model.Model;
import io.quassar.editor.model.ModelRelease;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class GetDownloadModelAction
extends QuassarAction {
    public String commit;

    public Resource execute() throws Forbidden {
        Model model = this.box.modelManager().find(this.commit);
        ModelRelease release = this.box.modelManager().findRelease(this.commit);
        if (model == null || release == null) {
            Logger.error((String)"Model commit %s not found".formatted(this.commit));
            return DisplayHelper.emptyFile();
        }
        try {
            File result = this.box.modelManager().release(model, release.version());
            return new Resource(ModelHelper.label(model, "es", this.box) + ".zip", (InputStream)new FileInputStream(result));
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return DisplayHelper.emptyFile();
        }
    }
}

