/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.MimeTypes;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.intino.alexandria.ui.utils.DelayerUtil;
import io.intino.builderservice.schemas.Message;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.commands.ModelCommands;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.models.ModelContainer;
import io.quassar.editor.box.schemas.IntinoDslEditorFileContent;
import io.quassar.editor.box.schemas.IntinoFileBrowserItem;
import io.quassar.editor.box.ui.displays.IntinoDslEditor;
import io.quassar.editor.box.ui.displays.templates.AbstractModelEditor;
import io.quassar.editor.box.ui.types.ModelView;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.FilePosition;
import io.quassar.editor.model.Model;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;

public class ModelEditor
extends AbstractModelEditor<EditorBox> {
    private Model model;
    private String release;
    private ModelView selectedView;
    private File selectedFile;
    private FilePosition selectedPosition;
    private File selectedNewFile;
    private ModelContainer modelContainer;
    private boolean selectedFileIsModified = false;
    private boolean openNewFile = false;
    private boolean showHelp = false;
    private boolean releaseChanged = false;

    public ModelEditor(EditorBox box) {
        super(box);
    }

    public void model(Model model, String release) {
        this.releaseChanged = this.releaseChanged || !release.equals(this.release);
        this.model = model;
        this.release = release;
        this.modelContainer = this.model != null ? ((EditorBox)this.box()).modelManager().modelContainer(this.model, this.release) : null;
    }

    public void view(ModelView view) {
        this.selectedView = view;
    }

    public void file(File file, FilePosition position) {
        this.selectedFile = file;
        this.selectedPosition = position;
    }

    public void showHelp(boolean value) {
        this.showHelp = value;
    }

    public void didMount() {
        super.didMount();
        if (this.model == null) {
            return;
        }
        this.createFileEditor();
        this.refresh();
    }

    @Override
    public void init() {
        super.init();
        this.initHeader();
        this.initBrowsers();
        this.initFileEditor();
        this.initFileModifiedDialog();
        this.initSettings();
        this.tabSelector.onSelect(e -> this.hideFooterBlocks());
        this.footerSelector.onSelect(e -> this.hideMainBlocks());
        this.helpDialog.onClose(e -> ((TemplateNotifier)this.notifier).dispatch(PathHelper.modelPath(this.model, this.release)));
        this.helpDialog.onOpen(e -> this.refreshHelpDialog());
        this.console.onClose(e -> this.consoleBlock.hide());
    }

    private void initSettings() {
        this.infoTrigger.onExecute(e -> this.openSettings());
        this.settingsBlock.onInit(e -> this.initSettingsBlock());
        this.settingsBlock.onShow(e -> this.refreshSettingsBlock());
    }

    private void initSettingsBlock() {
        this.settingsStamp.onSaveTitle(e -> this.refreshHeader());
        this.settingsStamp.onClone(e -> this.cloneModel());
        this.settingsStamp.onUpdateLanguageVersion(e -> this.updateLanguageVersion());
    }

    private void refreshSettingsBlock() {
        this.settingsStamp.model(this.model);
        this.settingsStamp.release(this.release);
        this.settingsStamp.refresh();
    }

    public void refresh() {
        super.refresh();
        this.refreshHeader();
        this.languageNotLoadedBlock.visible(this.modelContainer == null);
        this.refreshContent();
        if (this.showHelp) {
            this.helpDialog.open();
        }
    }

    private void refreshContent() {
        this.tabSelector.address(path -> PathHelper.modelViewPath(path, this.model, this.release));
        this.footerSelector.address(path -> PathHelper.modelViewPath(path, this.model, this.release));
        this.footerSelector.readonly(!PermissionsHelper.canEditSettings(this.model, this.release, this.session(), (EditorBox)this.box()));
        this.contentBlock.visible(this.model != null && this.modelContainer != null);
        this.modelEditionBlock.visible(this.selectedView != ModelView.Settings);
        if (!this.contentBlock.isVisible()) {
            return;
        }
        if (this.selectedFile != null) {
            this.tabSelector.select(new String[]{this.selectedFile.isResource() ? "resources" : "model"});
        } else if (this.selectedView != null) {
            if (this.selectedView == ModelView.Settings) {
                this.footerSelector.select(new String[]{"settings"});
            } else {
                this.tabSelector.select(new String[]{this.selectedView.name().toLowerCase()});
            }
        } else if (this.tabSelector.selection().isEmpty()) {
            this.tabSelector.select(new String[]{"model"});
        } else {
            this.tabSelector.select(new String[]{(String)this.tabSelector.selection().getFirst()});
        }
        this.refreshFile();
    }

    private void initHeader() {
        this.headerStamp.onCheck(m -> this.check());
        this.headerStamp.onClone(m -> this.cloneModel());
        this.headerStamp.onDeploy((m, e) -> this.updateConsole((Command.CommandResult)e));
    }

    private void initBrowsers() {
        this.modelBrowserBlock.onInit(e -> this.initModelBrowserBlock());
        this.modelBrowserBlock.onShow(e -> this.refreshModelBrowserBlock());
        this.resourcesBrowserBlock.onInit(e -> this.initResourcesBrowserBlock());
        this.resourcesBrowserBlock.onShow(e -> this.refreshResourcesBrowserBlock());
    }

    private void initModelBrowserBlock() {
        this.modelBrowserStamp.onChange(this::reloadAndOpen);
        this.modelBrowserStamp.onRemove(this::reloadAndUnselect);
        this.modelBrowserStamp.onOpen(this::open);
    }

    private void refreshModelBrowserBlock() {
        this.modelBrowserStamp.model(this.model);
        this.modelBrowserStamp.release(this.release);
        this.modelBrowserStamp.view(this.selectedView);
        this.modelBrowserStamp.modelContainer(this.modelContainer);
        this.modelBrowserStamp.file(this.selectedFile);
        this.modelBrowserStamp.refresh();
        if (this.intinoDslEditor.display() != null) {
            ((IntinoDslEditor)this.intinoDslEditor.display()).files(this.editorFiles());
        }
    }

    private void initResourcesBrowserBlock() {
        this.resourcesBrowserStamp.onChange(this::reloadAndOpen);
        this.resourcesBrowserStamp.onRemove(this::reloadAndUnselect);
        this.resourcesBrowserStamp.onOpen(this::open);
    }

    private void refreshResourcesBrowserBlock() {
        this.resourcesBrowserStamp.model(this.model);
        this.resourcesBrowserStamp.release(this.release);
        this.resourcesBrowserStamp.view(this.selectedView);
        this.resourcesBrowserStamp.modelContainer(this.modelContainer);
        this.resourcesBrowserStamp.file(this.selectedFile);
        this.resourcesBrowserStamp.refresh();
        if (this.intinoDslEditor.display() != null) {
            ((IntinoDslEditor)this.intinoDslEditor.display()).files(this.editorFiles());
        }
    }

    private void initFileEditor() {
        this.createFileEditor();
    }

    private IntinoDslEditor createFileEditor() {
        IntinoDslEditor editor = new IntinoDslEditor((EditorBox)this.box());
        this.intinoDslEditor.clear();
        this.intinoDslEditor.display(editor);
        editor.files(this.editorFiles());
        editor.onFileModified(e -> {
            if (this.selectedFileIsModified) {
                return;
            }
            this.selectedFileIsModified = true;
            this.fileSavedMessage.visible(false);
            this.refreshFileEditorToolbar();
        });
        editor.onSelectFile(this::refreshBrowserSelection);
        editor.onSaveFile(this::saveFile);
        editor.onBuild(e -> this.check());
        return editor;
    }

    private List<File> editorFiles() {
        if (this.modelContainer == null) {
            return Collections.emptyList();
        }
        return this.selectedView == null || this.selectedView == ModelView.Model ? this.modelContainer.modelFiles() : (this.selectedFile != null ? List.of(this.selectedFile) : Collections.emptyList());
    }

    private void initFileModifiedDialog() {
        this.fileModifiedDialog.onOpen(e -> this.fileModifiedDialog.title(this.selectedFile.name()));
        this.cancelSavingFile.onExecute(e -> {
            this.fileModifiedDialog.close();
            this.refreshFileBrowser();
        });
        this.continueSavingFile.onExecute(e -> {
            this.fileModifiedDialog.close();
            this.openNewFile = true;
            ((IntinoDslEditor)this.intinoDslEditor.display()).fireSavingProcess();
        });
        this.continueWithoutSavingFile.onExecute(e -> {
            this.fileModifiedDialog.close();
            this.selectedFileIsModified = false;
            this.open(this.selectedNewFile);
        });
    }

    private void refreshFileBrowser() {
        if (this.modelBrowserBlock.isVisible()) {
            this.refreshModelBrowserBlock();
        }
        if (this.resourcesBrowserBlock.isVisible()) {
            this.refreshResourcesBrowserBlock();
        }
    }

    private void saveFile(IntinoDslEditorFileContent content) {
        ((EditorBox)this.box()).commands(ModelCommands.class).save(this.model, this.modelContainer.file(content.file()), new ByteArrayInputStream(content.content().getBytes(StandardCharsets.UTF_8)), this.username());
        this.fileSavedMessage.visible(true);
        DelayerUtil.execute((Display)this, e -> this.fileSavedMessage.visible(false), (int)2000);
        this.selectedFileIsModified = false;
        if (this.openNewFile) {
            this.open(this.selectedNewFile);
        } else {
            this.refreshFileEditorToolbar();
        }
        this.headerStamp.checked(false);
    }

    private void refreshHeader() {
        this.headerStamp.model(this.model);
        this.headerStamp.release(this.release);
        this.headerStamp.view(this.selectedView);
        this.headerStamp.file(this.selectedFile);
        this.headerStamp.refresh();
    }

    private void refreshFile() {
        boolean isDirectory = this.selectedFile != null && this.selectedFile.isDirectory();
        boolean textFile = this.selectedFile != null && !isDirectory && ((EditorBox)this.box()).modelManager().isTextFile(this.model, this.release, this.selectedFile);
        this.fileNotSelectedBlock.visible(this.selectedFile == null || this.selectedFile.isDirectory());
        this.nonEditableFileBlock.visible(this.selectedFile != null && !isDirectory && !textFile);
        this.editableFileBlock.visible(textFile);
        this.filename.value(textFile ? this.withoutExtensionIfModelFile(this.selectedFile.name()) : "");
        this.refreshFileEditorToolbar();
        this.refreshEditableFileBlock();
        this.refreshNonEditableFileBlock();
    }

    private void refreshEditableFileBlock() {
        if (!this.editableFileBlock.isVisible()) {
            return;
        }
        IntinoDslEditor display = (IntinoDslEditor)this.intinoDslEditor.display();
        if (display == null) {
            display = this.createFileEditor();
        }
        display.model(this.model);
        display.release(this.release);
        display.view(this.selectedView);
        if (this.releaseChanged || !display.initialized()) {
            display.file(this.selectedFile, this.selectedPosition);
            display.refresh();
            this.releaseChanged = false;
        } else {
            display.openFile(this.selectedFile, this.selectedPosition);
        }
    }

    private void refreshNonEditableFileBlock() {
        if (!this.nonEditableFileBlock.isVisible()) {
            return;
        }
        this.fileField.value(new io.intino.alexandria.ui.File().filename(this.selectedFile.uri()).mimeType(MimeTypes.contentTypeOf((String)this.selectedFile.extension())).value(this.urlOf(PathHelper.commitFileFileUrl(this.model, this.release, this.selectedFile, this.session()))));
    }

    private String withoutExtensionIfModelFile(String name) {
        return File.isResource(name) ? name : name.replace(".tara", "");
    }

    private void open(IntinoFileBrowserItem item) {
        this.open(this.modelContainer.file(item.uri()));
    }

    private void open(File file) {
        this.openNewFile = false;
        this.selectedFile = file;
        this.refresh();
    }

    private void rename(IntinoFileBrowserItem item, String newName) {
        File file = this.modelContainer.file(item.name());
        file = ((EditorBox)this.box()).commands(ModelCommands.class).rename(this.model, newName, file, this.username());
        this.reload();
        this.open(file);
    }

    private void move(IntinoFileBrowserItem item, IntinoFileBrowserItem directoryItem) {
        File file = this.modelContainer.file(item.name());
        File directory = this.modelContainer.file(directoryItem.name());
        file = ((EditorBox)this.box()).commands(ModelCommands.class).move(this.model, file, directory, this.username());
        this.reload();
        this.open(file);
    }

    private void reload() {
        this.modelContainer = ((EditorBox)this.box()).modelManager().modelContainer(this.model, this.release);
        if (this.intinoDslEditor.display() != null) {
            ((IntinoDslEditor)this.intinoDslEditor.display()).files(this.editorFiles());
        }
        this.refresh();
    }

    private void refreshFileEditorToolbar() {
    }

    private void updateConsole(Command.CommandResult result) {
        this.consoleBlock.visible(!result.messages().isEmpty());
        if (!this.consoleBlock.isVisible()) {
            return;
        }
        this.updateConsole(result.messages());
    }

    private void updateConsole(List<Message> messages) {
        this.console.model(this.model);
        this.console.release(this.release);
        this.console.messages(messages);
        this.console.refresh();
        this.console.show();
    }

    private void reloadAndUnselect(File file) {
        this.selectedFile = null;
        this.reload();
    }

    private void reloadAndOpen(File file) {
        this.reload();
        if (file != null) {
            this.open(file);
        }
    }

    private boolean check() {
        this.notifyUser(this.translate("Checking model..."), UserMessage.Type.Loading);
        Command.CommandResult result = ((EditorBox)this.box()).commands(ModelCommands.class).check(this.model, this.username());
        this.headerStamp.checked(result.success());
        this.updateConsole(result);
        if (result.success()) {
            this.notifyUser("Model checked successfully", UserMessage.Type.Success);
        } else {
            this.hideUserNotification();
        }
        return result.success();
    }

    private void cloneModel() {
        this.notifyUser(this.translate("Cloning model..."), UserMessage.Type.Loading);
        Model newModel = ((EditorBox)this.box()).commands(ModelCommands.class).clone(this.model, this.release, ModelHelper.proposeName(), this.username());
        ((TemplateNotifier)this.notifier).dispatch(PathHelper.modelPath(newModel));
        this.notifyUser(this.translate("Model cloned"), UserMessage.Type.Success);
    }

    private void refreshHelpDialog() {
        String help = ((EditorBox)this.box()).languageManager().loadHelp(this.model.language());
        this.helpDialog.title("%s help".formatted(LanguageHelper.title(this.model.language())));
        this.helpStamp.content("<div class='help'>" + help + "</div>");
        this.helpStamp.refresh();
    }

    private URL urlOf(String url) {
        try {
            return new URI(url).toURL();
        }
        catch (MalformedURLException | URISyntaxException ignored) {
            return null;
        }
    }

    private void updateSelectedBlock(SelectionEvent event) {
        String selected;
        if (!this.model.isTemplate()) {
            return;
        }
        String string = selected = !event.selection().isEmpty() ? (String)event.selection().getFirst() : null;
        if (selected == null || selected.equalsIgnoreCase("model")) {
            this.modelBrowserBlock.show();
        } else {
            this.resourcesBrowserBlock.show();
        }
    }

    private File refreshBrowserSelection(String uri) {
        this.selectedFile = this.modelContainer.file(uri);
        boolean isDirectory = this.selectedFile != null && this.selectedFile.isDirectory();
        boolean textFile = this.selectedFile != null && !isDirectory && ((EditorBox)this.box()).modelManager().isTextFile(this.model, this.release, this.selectedFile);
        this.filename.value(textFile ? this.withoutExtensionIfModelFile(this.selectedFile.name()) : "");
        if (this.selectedView == null || this.selectedView == ModelView.Model) {
            this.modelBrowserStamp.selection(uri);
        } else {
            this.resourcesBrowserStamp.selection(uri);
        }
        return this.selectedFile;
    }

    private void openSettings() {
        this.tabSelector.selection(Collections.emptyList());
        this.footerSelector.select(new String[]{"settings"});
    }

    private void updateLanguageVersion() {
        ((TemplateNotifier)this.notifier).redirect(PathHelper.modelUrl(this.model, this.release, this.selectedView, this.selectedFile, this.selectedPosition, this.session()));
    }

    private void hideMainBlocks() {
        this.tabSelector.selection(Collections.emptyList());
        this.modelEditionBlock.hide();
        this.intinoDslEditor.clear();
    }

    private void hideFooterBlocks() {
        this.modelEditionBlock.show();
        this.footerSelector.selection(Collections.emptyList());
        this.settingsBlock.hide();
    }
}

