/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.events.AddCollectionItemEvent;
import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.intino.alexandria.ui.model.Datasource;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.datasources.CollaboratorsDatasource;
import io.quassar.editor.box.ui.displays.items.CollaboratorSelectorItem;
import io.quassar.editor.box.ui.displays.templates.AbstractCollaboratorsTemplate;
import io.quassar.editor.box.ui.displays.templates.CollaboratorItemTemplate;
import io.quassar.editor.model.Model;
import io.quassar.editor.model.User;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class CollaboratorsTemplate
extends AbstractCollaboratorsTemplate<EditorBox> {
    private Model model;
    private Consumer<List<User>> changeListener;
    private List<User> collaboratorList = new ArrayList<User>();

    public CollaboratorsTemplate(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
        this.collaboratorList = model.collaborators().stream().map(c -> ((EditorBox)this.box()).userManager().get((String)c)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void onChange(Consumer<List<User>> listener) {
        this.changeListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.collaboratorSelectorList.onAddItem(this::refresh);
        this.collaboratorSelector.onSelect(this::addCollaborator);
    }

    public void refresh() {
        super.refresh();
        this.noCollaboratorsBlock.visible(this.collaboratorList.isEmpty());
        this.collaboratorsBlock.visible(!this.collaboratorList.isEmpty());
        this.collaborators.clear();
        this.collaboratorList.forEach(u -> this.fill((User)u, (CollaboratorItemTemplate)this.collaborators.add()));
        this.refreshCollaboratorsSelector();
    }

    private void refreshCollaboratorsSelector() {
        this.collaboratorSelectorList.source((Datasource)new CollaboratorsDatasource((EditorBox)this.box(), this.session(), this.collaboratorList));
        this.collaboratorSelectorList.reload();
    }

    private void addCollaborator(SelectionEvent event) {
        if (event.selection().isEmpty()) {
            return;
        }
        this.addCollaborator((User)event.first());
    }

    private void addCollaborator(User user) {
        this.collaboratorList.stream().filter(u -> u.name().equals(user.name())).findFirst().ifPresent(this.collaboratorList::remove);
        this.collaboratorList.add(user);
        this.changeListener.accept(this.collaboratorList);
        this.refresh();
    }

    private void fill(User user, CollaboratorItemTemplate display) {
        display.user(user);
        display.onRemove(this::removeUser);
        display.refresh();
    }

    private void removeUser(User user) {
        this.collaboratorList.stream().filter(u -> u.name().equals(user.name())).findFirst().ifPresent(this.collaboratorList::remove);
        this.changeListener.accept(this.collaboratorList);
        this.refresh();
    }

    private void refresh(AddCollectionItemEvent event) {
        User user = (User)event.item();
        CollaboratorSelectorItem display = (CollaboratorSelectorItem)event.component();
        display.name.value(user.name());
    }
}

