/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.util;

import io.intino.alexandria.logger.Logger;
import io.quassar.archetype.Archetype;
import io.quassar.editor.box.util.ZipHelper;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactoryHelper {
    public static final String ReleasesPath = "/artifacts/releases";
    public static final String DependencyTemplate = "<dependency>\n\t<groupId>%s</groupId>\n\t<artifactId>%s</artifactId>\n\t<version>%s</version>\n</dependency>";
    public static final String RepositoryTemplate = "<repository>\n\t<id>Quassar</id>\n\t<url>%s/artifacts/releases</url>\n</repository>";
    public static final String ParsersDirectory = "/parsers/";
    public static final String ParserPrefix = "parser-";

    public static void prepareDsl(Language language, LanguageRelease release, Archetype.Languages archetype) {
        try {
            File jarFile = archetype.releaseDslJar(language.key(), release.version());
            if (jarFile == null || !jarFile.exists()) {
                return;
            }
            File destination = ArtifactoryHelper.extractJar(jarFile);
            File manifest = ArtifactoryHelper.locateManifest(destination);
            if (manifest == null) {
                ArtifactoryHelper.removeDirectory(destination);
                return;
            }
            Files.copy(manifest.toPath(), archetype.releaseDslManifest(language.key(), release.version()).toPath(), new CopyOption[0]);
            ArtifactoryHelper.removeDirectory(destination);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public static void prepareParserDependency(Language language, LanguageRelease release, String name, Archetype.Languages archetype) {
        File file = archetype.releaseParserFile(language.key(), release.version(), name);
        if (!file.exists()) {
            return;
        }
        File tempDir = ArtifactoryHelper.extractParserToDirectory(language, release, name, archetype, file);
        File jarFile = ArtifactoryHelper.locateJarFileInParser(release, tempDir);
        if (jarFile == null) {
            return;
        }
        File destination = ArtifactoryHelper.extractJar(jarFile);
        ArtifactoryHelper.modifyParserManifestAndCopy(destination, language, release, name, archetype);
        ArtifactoryHelper.removeDirectory(tempDir);
    }

    @Nullable
    private static File locateJarFileInParser(LanguageRelease release, File parserDirectory) {
        File[] files = parserDirectory.listFiles();
        if (files == null) {
            ArtifactoryHelper.removeDirectory(parserDirectory);
            return null;
        }
        File jarFile = Arrays.stream(files).filter(f -> f.getName().endsWith(release.version() + ".jar")).findFirst().orElse(null);
        if (jarFile == null) {
            ArtifactoryHelper.removeDirectory(parserDirectory);
            return null;
        }
        return jarFile;
    }

    @NotNull
    private static File extractParserToDirectory(Language language, LanguageRelease release, String name, Archetype.Languages archetype, File file) {
        File tempDir = archetype.releaseParserDir(language.key(), release.version(), name);
        if (tempDir.exists()) {
            ArtifactoryHelper.removeDirectory(tempDir);
        }
        ZipHelper.extract(file, tempDir);
        File file2 = tempDir;
        if (file2 == null) {
            ArtifactoryHelper.$$$reportNull$$$0(0);
        }
        return file2;
    }

    private static File extractJar(File jarFile) {
        File destination = new File(jarFile.getAbsolutePath().replace(".jar", ""));
        ZipHelper.extract(jarFile, destination);
        return destination;
    }

    private static void modifyParserManifestAndCopy(File jarDir, Language language, LanguageRelease release, String name, Archetype.Languages archetype) {
        try {
            File manifest = ArtifactoryHelper.locateManifest(jarDir);
            if (manifest == null) {
                return;
            }
            File manifestDestination = archetype.releaseParserManifest(language.key(), release.version(), name);
            Files.writeString(manifestDestination.toPath(), (CharSequence)ArtifactoryHelper.manifestOf(manifest, ArtifactoryHelper.dependencyGroup(language), ArtifactoryHelper.dependencyName(archetype.releaseParserFile(language.key(), release.version(), name)), release.version()), new OpenOption[0]);
            Files.writeString(manifest.toPath(), (CharSequence)ArtifactoryHelper.manifestOf(manifest, ArtifactoryHelper.dependencyGroup(language), ArtifactoryHelper.dependencyName(archetype.releaseParserFile(language.key(), release.version(), name)), release.version()), new OpenOption[0]);
            ZipHelper.zip(jarDir.toPath(), archetype.releaseParserJar(language.key(), release.version(), name).toPath());
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    private static File locateManifest(File jarDir) {
        File file;
        block8: {
            Stream<Path> paths = Files.walk(jarDir.toPath(), new FileVisitOption[0]);
            try {
                file = paths.map(Path::toFile).filter(p -> p.getName().equals("pom.xml")).findFirst().orElse(null);
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Logger.error((Throwable)e);
                    return null;
                }
            }
            paths.close();
        }
        return file;
    }

    private static String manifestOf(File file, String groupId, String artifactId, String version) throws IOException {
        if (file == null) {
            return null;
        }
        String content = Files.readString(file.toPath());
        content = content.replaceFirst("<groupId>.*?</groupId>", "<groupId>" + groupId + "</groupId>");
        content = content.replaceFirst("<artifactId>.*?</artifactId>", "<artifactId>" + artifactId + "</artifactId>");
        content = content.replaceFirst("<version>.*?</version>", "<version>" + version + "</version>");
        return content;
    }

    public static String dependency(Language language, String version, File dependency) {
        return DependencyTemplate.formatted(ArtifactoryHelper.dependencyGroup(language), ArtifactoryHelper.dependencyName(dependency), version);
    }

    public static String repository(String url) {
        return RepositoryTemplate.formatted(url);
    }

    public static GavCoordinates parse(String path) {
        String[] parts = path.split("/");
        if (parts.length < 4) {
            return null;
        }
        String version = parts[parts.length - 2];
        String artifactId = parts[parts.length - 3];
        StringBuilder groupIdBuilder = new StringBuilder();
        for (int i = 0; i < parts.length - 3; ++i) {
            if (i > 0) {
                groupIdBuilder.append(".");
            }
            groupIdBuilder.append(parts[i]);
        }
        return new GavCoordinates(groupIdBuilder.toString(), artifactId, version);
    }

    public static String parserNameFor(String artifactId) {
        return artifactId.replace(ParserPrefix, "");
    }

    public static String dependencyGroup(Language language) {
        return (language.group() != null && !language.group().isEmpty() ? language.group() : "io.quassar") + "." + language.name();
    }

    public static String dependencyName(File dependency) {
        String extension = FilenameUtils.getExtension((String)dependency.getName());
        String prefix = dependency.getAbsolutePath().contains(ParsersDirectory) ? ParserPrefix : "";
        return prefix + dependency.getName().replace("." + extension, "");
    }

    private static void removeDirectory(File destination) {
        try {
            if (!destination.exists()) {
                return;
            }
            FileUtils.deleteDirectory((File)destination);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/quassar/editor/box/util/ArtifactoryHelper", "extractParserToDirectory"));
    }
}

