/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.Actionable;
import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.ui.displays.templates.AbstractModelHeaderTemplate;
import io.quassar.editor.box.ui.types.ModelView;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import java.util.ArrayList;
import java.util.List;
import java.util.SequencedCollection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class ModelHeaderTemplate
extends AbstractModelHeaderTemplate<EditorBox> {
    private Model model;
    private String release;
    private ModelView view;
    private File file;
    private Function<Model, Boolean> checkListener;
    private Consumer<Model> cloneListener;
    private BiConsumer<Model, Command.CommandResult> deployListener;
    private Step step = Step.Edit;
    private boolean checked = false;
    private static final String DefaultExecutionName = "4. execute";

    public ModelHeaderTemplate(EditorBox box) {
        super(box);
    }

    public Model model() {
        return this.model;
    }

    public void model(Model model) {
        this.model = model;
    }

    public void release(String value) {
        this.release = value;
    }

    public void view(ModelView value) {
        this.view = value;
    }

    public void file(File value) {
        this.file = value;
    }

    public void onCheck(Function<Model, Boolean> listener) {
        this.checkListener = listener;
    }

    public void onClone(Consumer<Model> listener) {
        this.cloneListener = listener;
    }

    public void onDeploy(BiConsumer<Model, Command.CommandResult> listener) {
        this.deployListener = listener;
    }

    public void checked(boolean value) {
        this.updateStep(value ? Step.Check : Step.Edit);
    }

    @Override
    public void init() {
        super.init();
        this.releaseSelector.onExecute(e -> this.openRelease(e.option()));
        this.editTrigger.onExecute(e -> this.edit());
        this.checkTrigger.onExecute(e -> this.check());
        this.commitTrigger.onExecute(e -> this.commit());
        this.downloadTrigger.onExecute(e -> this.openDownloadDialog());
        this.forgeTrigger.onOpen(e -> this.updateStep(Step.Forge));
        this.cloneTrigger.onExecute(e -> this.cloneModel());
        this.commitModelDialog.onCommit((m, v) -> this.openRelease((String)v));
        this.commitModelDialog.onCommitFailure((m, v) -> this.deployListener.accept((Model)m, (Command.CommandResult)v));
        this.commitModelDialog.onCreateRelease((m, v) -> this.deployListener.accept((Model)m, (Command.CommandResult)v));
        this.executionTrigger.onExecute(e -> this.openExecutionLauncher());
    }

    public void refresh() {
        super.refresh();
        this.contentBlock.visible(this.model != null);
        if (!this.contentBlock.isVisible()) {
            return;
        }
        Language language = ((EditorBox)this.box()).languageManager().get(this.model);
        this.step = !"draft".equals(this.release) ? Step.Commit : (this.checked ? Step.Check : Step.Edit);
        this.checked = false;
        this.titleViewer.model(this.model);
        this.titleViewer.refresh();
        this.refreshReleaseSelector();
        this.refreshToolbar();
        this.languageLogo.visible(language != null);
        if (this.languageLogo.isVisible()) {
            this.languageLogo.value(LanguageHelper.logo(language, (EditorBox)this.box()));
        }
        this.refreshHelpTrigger(language);
        this.refreshMetamodelTrigger(language);
        this.refreshLanguageTrigger(language);
        this.refreshCloseTrigger(language);
    }

    private void refreshHelpTrigger(Language language) {
        this.helpTrigger.visible(language != null && !PermissionsHelper.hasAccessToMetamodel(language, this.session(), (EditorBox)this.box()));
        if (!this.helpTrigger.isVisible()) {
            return;
        }
        this.helpTrigger.title(LanguageHelper.title(this.model.language()));
        this.helpTrigger.site(PathHelper.languageReleaseHelp(language, this.model.language().version()));
    }

    private void refreshMetamodelTrigger(Language language) {
        this.metamodelTrigger.visible(language != null && PermissionsHelper.hasAccessToMetamodel(language, this.session(), (EditorBox)this.box()));
        if (!this.metamodelTrigger.isVisible()) {
            return;
        }
        this.metamodelTrigger.title(LanguageHelper.title(this.model.language()));
        this.metamodelTrigger.site(PathHelper.modelUrl(((EditorBox)this.box()).modelManager().get(language.metamodel()), this.model.language().version(), this.session()));
    }

    private void refreshLanguageTrigger(Language language) {
        this.languageTrigger.visible(language != null && !this.model.isTemplate() && !PathHelper.comesFromForge(this.session()));
        if (!this.languageTrigger.isVisible() || language == null) {
            return;
        }
        this.languageTrigger.title(this.translate("Goto %s").formatted(LanguageHelper.title(this.model.language())));
        this.languageTrigger.address(path -> PathHelper.languagePath(path, language));
    }

    private void refreshCloseTrigger(Language language) {
        this.closeTrigger.visible(language != null && this.model.isTemplate() || PathHelper.comesFromForge(this.session()));
        if (!this.closeTrigger.isVisible()) {
            return;
        }
        this.closeTrigger.title(this.translate(this.model.isTemplate() ? "Template" : "Example"));
    }

    private void refreshToolbar() {
        Language language = ((EditorBox)this.box()).languageManager().get(this.model);
        Language forgedLanguage = ((EditorBox)this.box()).languageManager().getWithMetamodel(this.model);
        this.editTrigger.highlight(this.step == Step.Edit ? Actionable.Highlight.Fill : Actionable.Highlight.Outline);
        this.editTrigger.visible(!this.model.isTemplate() && !this.model.isExample());
        this.checkTrigger.readonly(!PermissionsHelper.canCheck(this.model, this.release, this.session(), (EditorBox)this.box()));
        this.checkTrigger.visible(PermissionsHelper.isOwnerOrCollaborator(this.model, this.session(), (EditorBox)this.box()));
        this.checkTrigger.highlight(this.step == Step.Check && !this.model.isTemplate() && !this.model.isExample() ? Actionable.Highlight.Fill : Actionable.Highlight.Outline);
        this.checkTrigger.title(this.model.isTemplate() || this.model.isExample() ? this.translate("Check") : this.translate("2. Check"));
        this.commitTrigger.visible(!this.model.isTemplate() && !this.model.isExample());
        this.commitTrigger.readonly(this.step == Step.Edit || !PermissionsHelper.canCommit(this.model, this.release, this.session(), (EditorBox)this.box()));
        this.commitTrigger.highlight(this.step == Step.Commit ? Actionable.Highlight.Fill : Actionable.Highlight.Outline);
        this.forgeTrigger.visible(!this.model.isTemplate() && this.release != null && this.model.language().artifactId().equals("metta"));
        this.forgeTrigger.readonly(this.step == Step.Edit || this.release == null || this.release.equals("draft") || !PermissionsHelper.canForge(this.model, language, this.release, this.session(), (EditorBox)this.box()));
        this.forgeTrigger.highlight(this.step == Step.Forge ? Actionable.Highlight.Fill : Actionable.Highlight.Outline);
        if (this.forgeTrigger.isVisible()) {
            this.forgeTrigger.site(PathHelper.forgeUrl(this.model, this.release, this.session()));
        }
        this.executionTrigger.visible(!this.model.isTemplate() && !this.model.isExample() && ModelHelper.isM1Release(this.model, this.release));
        if (this.executionTrigger.isVisible()) {
            this.executionTrigger.title(this.executionName());
        }
        this.executionTrigger.readonly(this.step == Step.Edit || this.release == null || this.release.equals("draft") || !PermissionsHelper.canLaunchExecution(this.model, language, this.release, this.session(), (EditorBox)this.box()));
        this.executionTrigger.highlight(this.step == Step.Forge ? Actionable.Highlight.Fill : Actionable.Highlight.Outline);
        this.downloadTrigger.visible(ModelHelper.validReleaseName(this.release, arg_0 -> ((ModelHeaderTemplate)this).translate(arg_0)));
        this.cloneTrigger.visible(this.session().user() != null && this.model.isExample() && !PermissionsHelper.isOwnerOrCollaborator(this.model, this.session(), (EditorBox)this.box()));
        this.noLanguageDefinedBlock.visible(!this.model.isTemplate() && this.model.language().artifactId().equals("metta") && (forgedLanguage == null || this.model.releases().isEmpty()));
        this.languageDefinedBlock.visible(forgedLanguage != null && !this.model.isTemplate() && this.model.language().artifactId().equals("metta") && !this.model.releases().isEmpty());
        if (this.languageDefinedBlock.isVisible()) {
            this.gotoForgeTrigger.site(PathHelper.forgeUrl(this.model, this.release, this.session()));
            this.gotoForgeTrigger.title(forgedLanguage.name() + " DSL");
        }
        this.releaseSelector.visible(!this.model.isTemplate() && !this.model.isExample() && !this.model.releases().isEmpty());
    }

    private void refreshReleaseSelector() {
        this.releaseSelector.visible(!this.model.isTemplate());
        if (!this.releaseSelector.isVisible()) {
            return;
        }
        this.releaseSelector.clear();
        SequencedCollection options = new ArrayList<String>(((EditorBox)this.box()).modelManager().releases(this.model)).reversed();
        this.releaseSelector.options((List)options);
        this.releaseSelector.option(this.release != null ? this.release : null);
    }

    private void openRelease(String release) {
        String releaseName = release.equals(this.translate("draft")) ? "draft" : release;
        ((TemplateNotifier)this.notifier).dispatch(PathHelper.modelPath(this.model, releaseName, this.view, this.file));
    }

    private void edit() {
        this.openRelease("draft");
        this.refreshToolbar();
    }

    private void check() {
        if (!"draft".equals(this.release)) {
            this.openRelease("draft");
            this.checked = true;
        }
        this.updateStep(this.checkListener.apply(this.model) != false ? Step.Check : Step.Edit);
    }

    private void commit() {
        this.commitModelDialog.model(this.model);
        this.commitModelDialog.open();
        this.updateStep(Step.Commit);
    }

    private void cloneModel() {
        this.cloneListener.accept(this.model);
    }

    private void openDownloadDialog() {
        this.downloadModelDialog.model(this.model);
        this.downloadModelDialog.release(this.release);
        this.downloadModelDialog.open();
    }

    private void openExecutionLauncher() {
        this.executionLauncher.model(this.model);
        this.executionLauncher.release(this.release);
        this.executionLauncher.launch();
        this.updateStep(Step.Forge);
    }

    private String executionName() {
        Language language = ((EditorBox)this.box()).languageManager().get(this.model.language());
        if (language == null) {
            return this.translate(DefaultExecutionName);
        }
        LanguageRelease languageRelease = language.release(this.model.language().version());
        if (languageRelease == null) {
            return this.translate(DefaultExecutionName);
        }
        if (languageRelease.execution() == null) {
            return this.translate(DefaultExecutionName);
        }
        String name = languageRelease.execution().name();
        return this.translate((String)(!name.isEmpty() ? "4. " + name : DefaultExecutionName));
    }

    private void updateStep(Step step) {
        this.step = step;
        this.refreshToolbar();
    }

    private static enum Step {
        Edit,
        Check,
        Commit,
        Forge;

    }
}

