/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguageHeaderTemplate;
import io.quassar.editor.box.ui.types.LanguageTab;
import io.quassar.editor.box.ui.types.LanguageView;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.Language;

public class LanguageHeaderTemplate
extends AbstractLanguageHeaderTemplate<EditorBox> {
    private Language language;
    private LanguageTab tab;
    private LanguageView view;

    public LanguageHeaderTemplate(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void tab(LanguageTab tab) {
        this.tab = tab;
    }

    public void view(LanguageView view) {
        this.view = view;
    }

    @Override
    public void init() {
        super.init();
    }

    public void refresh() {
        super.refresh();
        if (this.language == null) {
            return;
        }
        String owner = ((EditorBox)this.box()).languageManager().owner(this.language);
        this.metamodelLink.visible(false);
        if (this.metamodelLink.isVisible()) {
            this.metamodelLink.address(path -> PathHelper.modelPath(((EditorBox)this.box()).modelManager().get(this.language.metamodel())));
        }
        this.refreshModels();
        this.refreshExamples();
        this.refreshHelp();
        this.refreshAbout();
    }

    private void refreshModels() {
        this.modelsText.visible(this.user() != null && this.tab == LanguageTab.Models);
        this.modelsLink.visible(this.user() != null && this.tab == LanguageTab.Examples);
        if (this.modelsLink.isVisible()) {
            this.modelsLink.address(a -> PathHelper.languagePath(a, this.language, LanguageTab.Models, this.view));
        }
    }

    private void refreshExamples() {
        boolean hasExamples = LanguageHelper.hasExamples(this.language);
        this.examplesText.visible(hasExamples && (this.tab == null || this.tab == LanguageTab.Examples));
        this.examplesLink.visible(hasExamples && (this.tab == null || this.tab == LanguageTab.Models));
        if (this.examplesLink.isVisible()) {
            this.examplesLink.address(a -> PathHelper.languagePath(a, this.language, LanguageTab.Examples, this.view));
        }
    }

    private void refreshHelp() {
        this.helpText.visible(this.view == LanguageView.Help);
        this.helpLink.visible(this.view == LanguageView.About);
        if (this.helpLink.isVisible()) {
            this.helpLink.address(a -> PathHelper.languagePath(a, this.language, this.tab, LanguageView.Help));
        }
    }

    private void refreshAbout() {
        this.aboutText.visible(this.view == LanguageView.About);
        this.aboutLink.visible(this.view == LanguageView.Help);
        if (this.aboutLink.isVisible()) {
            this.aboutLink.address(a -> PathHelper.languagePath(a, this.language, this.tab, LanguageView.About));
        }
    }
}

