/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.datasources.LanguagesWithReleaseDatasource;
import io.quassar.editor.box.ui.displays.templates.AbstractLandingTemplate;
import io.quassar.editor.box.ui.types.LandingDialog;
import io.quassar.editor.box.ui.types.LanguageTab;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.Model;
import java.util.List;
import java.util.Set;

public class LandingTemplate
extends AbstractLandingTemplate<EditorBox> {
    private LandingDialog dialog;
    private boolean closing = false;

    public LandingTemplate(EditorBox box) {
        super(box);
    }

    public void open(String dialog) {
        this.dialog = dialog != null ? LandingDialog.from(dialog) : null;
        this.refresh();
    }

    public void didMount() {
        super.didMount();
        this.content.cssSelectors(Set.of("landing-page"));
    }

    @Override
    public void init() {
        super.init();
        this.modelsDialog.onOpen(e -> this.refreshModelsDialog());
        this.modelsDialog.onClose(e -> this.notifyClose());
        this.languagesDialog.onOpen(e -> this.refreshLanguagesDialog());
        this.languagesDialog.onClose(e -> this.notifyClose());
        this.startModelingLogin.onExecute(e -> this.gotoLogin(PathHelper.landingUrl(LandingDialog.StartModeling, this.session())));
        this.startBuildingLogin.onExecute(e -> this.gotoLogin(PathHelper.homeUrl(this.session())));
        this.exploreLanguageLogin.onExecute(e -> this.gotoLogin(PathHelper.homeUrl(this.session())));
    }

    public void refresh() {
        super.refresh();
        this.refreshMainBlocks();
        this.refreshLanguagesCatalog();
        this.openDialogIfRequired();
    }

    private void refreshMainBlocks() {
        this.startModelingLogin.visible(this.user() == null);
        this.startModeling.visible(this.user() != null);
        if (this.startModeling.isVisible()) {
            this.startModeling.address(path -> PathHelper.landingPath(path, LandingDialog.StartModeling));
        }
        Language language = ((EditorBox)this.box()).languageManager().get("metta");
        List<Model> models = ((EditorBox)this.box()).modelManager().models(language);
        this.startBuilding.address(path -> PathHelper.languagePath(path, language, this.username() == null || models.isEmpty() ? LanguageTab.Examples : LanguageTab.Models));
        this.startBuilding.visible(this.user() != null);
        this.startBuildingLogin.visible(this.user() == null);
        this.exploreLanguage.address(path -> PathHelper.languagePath(path, language, this.username() == null || models.isEmpty() ? LanguageTab.Examples : LanguageTab.Models));
        this.exploreLanguage.visible(this.user() != null);
        this.exploreLanguageLogin.visible(this.user() == null);
    }

    private void refreshLanguagesCatalog() {
        this.languagesCatalog.refresh();
    }

    private void openDialogIfRequired() {
        if (this.dialog == null) {
            this.closing = true;
            this.languagesDialog.close();
            this.modelsDialog.close();
        }
        if (this.dialog == LandingDialog.Languages) {
            this.languagesDialog.open();
        } else if (this.dialog == LandingDialog.Examples) {
            this.modelsDialog.open();
        } else if (this.dialog == LandingDialog.StartModeling) {
            this.languagesDialog.open();
        }
    }

    private void refreshModelsDialog() {
        this.closing = false;
        this.modelsDialog.title("Example Metta models");
        this.modelsStamp.language(((EditorBox)this.box()).languageManager().get(Language.key("io.quassar", "metta")));
        this.modelsStamp.tab(LanguageTab.Examples);
        this.modelsStamp.refresh();
    }

    private void refreshLanguagesDialog() {
        this.closing = false;
        this.languagesDialog.title(this.dialog == LandingDialog.StartModeling ? "Select the DSL to start modeling with" : "Explore DSLs of our community");
        this.languagesStamp.onSelect(this.dialog == LandingDialog.StartModeling ? this::startModeling : null);
        this.languagesStamp.source(new LanguagesWithReleaseDatasource((EditorBox)this.box(), this.session()));
        this.languagesStamp.refresh();
    }

    private void startModeling(Language language) {
        ((TemplateNotifier)this.notifier).dispatch(PathHelper.languagePath(language));
    }

    private void startBuilding() {
        this.startModeling(((EditorBox)this.box()).languageManager().get(Language.key("io.quassar", "metta")));
    }

    private void notifyClose() {
        if (this.closing) {
            return;
        }
        ((TemplateNotifier)this.notifier).dispatch(PathHelper.homePath());
    }

    private void gotoLogin(String callback) {
        this.session().add("callback", callback);
        if (((EditorBox)this.box()).authService() == null) {
            ((TemplateNotifier)this.notifier).redirect(PathHelper.loginUrl(this.session()));
        } else {
            ((TemplateNotifier)this.notifier).redirect(this.session().login(this.session().browser().baseUrl()));
        }
    }
}

