/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.commands.Commands;
import io.quassar.editor.box.commands.language.CreateLanguageCommand;
import io.quassar.editor.box.commands.language.CreateLanguageReleaseCommand;
import io.quassar.editor.box.commands.language.CreateLanguageReleaseExecutionCommand;
import io.quassar.editor.box.commands.language.RemoveLanguageCommand;
import io.quassar.editor.box.commands.language.RenameLanguageCommand;
import io.quassar.editor.box.commands.language.SaveLanguageCommand;
import io.quassar.editor.box.commands.language.SaveLanguageHelpCommand;
import io.quassar.editor.box.commands.language.SaveLanguagePropertyCommand;
import io.quassar.editor.box.commands.language.SaveLanguageReleaseExecutionCommand;
import io.quassar.editor.box.commands.language.SaveLanguageReleaseExecutionPropertiesCommand;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageExecution;
import io.quassar.editor.model.LanguageProperty;
import io.quassar.editor.model.Model;
import java.io.File;
import java.util.List;

public class LanguageCommands
extends Commands {
    public LanguageCommands(EditorBox box) {
        super(box);
    }

    public Language create(String id, Model metamodel, Language.Level level, File logo, String username) {
        CreateLanguageCommand command = this.setup(new CreateLanguageCommand(this.box), username);
        command.id = id;
        command.metamodel = metamodel;
        command.level = level;
        command.logo = logo;
        return command.execute();
    }

    public Command.CommandResult createRelease(Language language, String version, String username) {
        CreateLanguageReleaseCommand command = this.setup(new CreateLanguageReleaseCommand(this.box), username);
        command.language = language;
        command.version = version;
        return command.execute();
    }

    public void save(Language language, LanguageProperty property, Object value, String username) {
        SaveLanguagePropertyCommand command = this.setup(new SaveLanguagePropertyCommand(this.box), username);
        command.language = language;
        command.property = property;
        command.value = value;
        command.execute();
    }

    public boolean rename(Language language, String newName, String username) {
        RenameLanguageCommand command = this.setup(new RenameLanguageCommand(this.box), username);
        command.language = language;
        command.newId = newName;
        return command.execute();
    }

    public void save(Language language, String title, String description, Language.Level level, List<String> tags, File logo, String username) {
        SaveLanguageCommand command = this.setup(new SaveLanguageCommand(this.box), username);
        command.language = language;
        command.title = title;
        command.description = description;
        command.level = level;
        command.tags = tags;
        command.logo = logo;
        command.execute();
    }

    public void saveHelp(Language language, String release, String content, String username) {
        SaveLanguageHelpCommand command = this.setup(new SaveLanguageHelpCommand(this.box), username);
        command.language = language;
        command.release = release;
        command.content = content;
        command.execute();
    }

    public Boolean remove(Language language, String username) {
        RemoveLanguageCommand command = this.setup(new RemoveLanguageCommand(this.box), username);
        command.language = language;
        return command.execute();
    }

    public LanguageExecution createExecution(Language language, String release, String name, LanguageExecution.Type type, String username) {
        CreateLanguageReleaseExecutionCommand command = this.setup(new CreateLanguageReleaseExecutionCommand(this.box), username);
        command.language = language;
        command.release = release;
        command.name = name;
        command.type = type;
        return command.execute();
    }

    public void saveExecution(Language language, String release, String name, LanguageExecution.Type type, String content, String username) {
        SaveLanguageReleaseExecutionCommand command = this.setup(new SaveLanguageReleaseExecutionCommand(this.box), username);
        command.language = language;
        command.release = release;
        command.name = name;
        command.type = type;
        command.content = content;
        command.execute();
    }

    public void saveExecutionProperties(Language language, String release, String installationUrl, String username) {
        SaveLanguageReleaseExecutionPropertiesCommand command = this.setup(new SaveLanguageReleaseExecutionPropertiesCommand(this.box), username);
        command.language = language;
        command.release = release;
        command.installationUrl = installationUrl;
        command.execute();
    }
}

