/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractModelTitleViewer;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.Model;

public class ModelTitleViewer
extends AbstractModelTitleViewer<EditorBox> {
    private Model model;

    public ModelTitleViewer(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    @Override
    public void init() {
        super.init();
        this.titleDialog.onSave(e -> this.refresh());
        this.simpleTitleBlock.onInit(e -> this.initSimpleTitleBlock());
        this.simpleTitleBlock.onShow(e -> this.refreshSimpleTitleBlock());
        this.qualifiedTitleBlock.onInit(e -> this.initQualifiedTitleBlock());
        this.qualifiedTitleBlock.onShow(e -> this.refreshQualifiedTitleBlock());
        this.projectBlock.onOpen(e -> this.refreshProjectBlock());
        this.moduleBlock.onOpen(e -> this.refreshModuleBlock());
    }

    public void refresh() {
        super.refresh();
        this.qualifiedTitleBlock.hide();
        this.simpleTitleBlock.hide();
        if (this.model.isTitleQualified()) {
            this.qualifiedTitleBlock.show();
        } else {
            this.simpleTitleBlock.show();
        }
    }

    private void openDialog() {
        this.titleDialog.model(this.model);
        this.titleDialog.open();
    }

    private void initSimpleTitleBlock() {
        this.title.onExecute(e -> this.openDialog());
    }

    private void refreshSimpleTitleBlock() {
        this.title.title(ModelHelper.label(this.model, this.language(), (EditorBox)this.box()));
        this.title.readonly(!PermissionsHelper.canEditTitle(this.model, (EditorBox)this.box()));
    }

    private void initQualifiedTitleBlock() {
        this.editTitleTrigger.onExecute(e -> this.openDialog());
    }

    private void refreshQualifiedTitleBlock() {
        this.project.title(this.model.project());
        this.module.title(this.model.module());
        this.editTitleTrigger.readonly(!PermissionsHelper.canEditTitle(this.model, (EditorBox)this.box()));
    }

    private void refreshProjectBlock() {
        this.projectBlock.projectViewer.model(this.model);
        this.projectBlock.projectViewer.onSelect(e -> this.projectBlock.close());
        this.projectBlock.projectViewer.project(this.model.project());
        this.projectBlock.projectViewer.refresh();
    }

    private void refreshModuleBlock() {
        this.moduleBlock.moduleBlockTitle.value(this.translate("MODELS"));
        this.moduleBlock.moduleViewer.onSelect(e -> this.moduleBlock.close());
        this.moduleBlock.moduleViewer.model(this.model);
        this.moduleBlock.moduleViewer.module(this.model.module());
        this.moduleBlock.moduleViewer.showTitle(false);
        this.moduleBlock.moduleViewer.refresh();
    }
}

