/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;
import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.LanguageCommands;
import io.quassar.editor.box.commands.ModelCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractModelSettingsDialog;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageProperty;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import io.quassar.editor.model.User;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class ModelSettingsDialog
extends AbstractModelSettingsDialog<EditorBox> {
    private Model model;
    private Consumer<Model> saveListener;
    private Consumer<Model> updateLanguageVersionListener;
    private Boolean accessType = null;
    private List<User> collaboratorList = null;
    private String token;

    public ModelSettingsDialog(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    public void onSave(Consumer<Model> listener) {
        this.saveListener = listener;
    }

    public void onUpdateLanguageVersion(Consumer<Model> listener) {
        this.updateLanguageVersionListener = listener;
    }

    public void open() {
        this.dialog.open();
    }

    @Override
    public void init() {
        super.init();
        this.generalBlock.onInit(e -> this.initGeneralBlock());
        this.generalBlock.onShow(e -> this.refreshGeneralBlock());
        this.collaboratorsBlock.onInit(e -> this.initCollaboratorsBlock());
        this.collaboratorsBlock.onShow(e -> this.refreshCollaboratorsBlock());
        this.dialog.onOpen(e -> this.refreshDialog());
        this.saveSettings.onExecute(e -> this.saveSettings());
    }

    private void refreshDialog() {
        this.dialog.title(this.translate("Information of %s").formatted(ModelHelper.label(this.model, this.language(), (EditorBox)this.box())));
        Language language = ((EditorBox)this.box()).languageManager().get(this.model);
        if (language == null) {
            this.settingsTabSelector.hideOption("languageOption");
        }
        this.settingsTabSelector.select(0);
    }

    private void initGeneralBlock() {
        this.removeModel.onExecute(e -> this.removeModel());
    }

    private void refreshGeneralBlock() {
        Language language = ((EditorBox)this.box()).languageManager().get(this.model.language());
        boolean canRemove = PermissionsHelper.canRemove(this.model, this.session(), (EditorBox)this.box());
        this.modelTitleField.readonly(!PermissionsHelper.canEditTitle(this.model, (EditorBox)this.box()));
        this.modelTitleField.value(ModelHelper.label(this.model, this.language(), (EditorBox)this.box()));
        this.modelDescriptionField.value(this.model.description());
        this.languageName.value(this.model.language().languageId());
        this.languageSelector.clear();
        this.languageSelector.addAll((List)language.releases().stream().map(LanguageRelease::version).toList().reversed());
        this.languageSelector.selection(new String[]{this.model.language().version()});
        this.removeModel.readonly(!canRemove);
        this.removeModel.formats(Set.of("airRight", "whiteColor", canRemove ? "redBackground" : "greyHardBackground"));
        this.accessType = this.model.isPrivate();
        this.accessTypeField.state(this.model.isPrivate() ? ToggleEvent.State.On : ToggleEvent.State.Off);
    }

    private void initCollaboratorsBlock() {
        this.collaboratorsStamp.onChange(e -> {
            this.collaboratorList = e;
        });
    }

    private void refreshCollaboratorsBlock() {
        this.collaboratorsStamp.model(this.model);
        this.collaboratorsStamp.refresh();
    }

    private void saveSettings() {
        if (!this.check()) {
            return;
        }
        this.dialog.close();
        this.saveModel();
        this.saveListener.accept(this.model);
    }

    private boolean check() {
        return DisplayHelper.check(this.modelTitleField, arg_0 -> ((ModelSettingsDialog)this).translate(arg_0));
    }

    private void saveModel() {
        ((EditorBox)this.box()).commands(ModelCommands.class).saveProperties(this.model, this.modelTitleField.value(), this.modelDescriptionField.value(), this.username());
        this.saveAccessType();
        this.saveLanguage();
        this.saveCollaborators();
    }

    private void saveAccessType() {
        boolean isPrivate;
        if (this.accessType == null) {
            return;
        }
        boolean bl = isPrivate = this.accessTypeField.state() == ToggleEvent.State.On;
        if (isPrivate) {
            ((EditorBox)this.box()).commands(ModelCommands.class).makePrivate(this.model, this.username());
        } else {
            ((EditorBox)this.box()).commands(ModelCommands.class).makePublic(this.model, this.username());
        }
    }

    private void saveLanguage() {
        String selected;
        List selection = this.languageSelector.selection();
        String string = selected = !selection.isEmpty() ? (String)selection.getFirst() : null;
        if (this.model.language().version().equals(selected)) {
            return;
        }
        ((EditorBox)this.box()).commands(ModelCommands.class).updateLanguageVersion(this.model, selected, this.username());
        this.updateLanguageVersionListener.accept(this.model);
    }

    private void saveCollaborators() {
        if (this.collaboratorList == null) {
            return;
        }
        ((EditorBox)this.box()).commands(ModelCommands.class).save(this.model, this.collaboratorList, this.username());
    }

    private void removeModel() {
        this.notifyUser(this.translate("Removing model..."), UserMessage.Type.Loading);
        String language = this.model.language().artifactId();
        ((EditorBox)this.box()).commands(ModelCommands.class).remove(this.model, this.username());
        this.hideUserNotification();
        ((TemplateNotifier)this.notifier).dispatch(PathHelper.languagePath(language));
    }

    private void saveLanguageProperties() {
        Language language = ((EditorBox)this.box()).languageManager().get(this.model);
        if (language == null) {
            return;
        }
        ((EditorBox)this.box()).commands(LanguageCommands.class).save(language, LanguageProperty.Title, this.model.title(), this.username());
        ((EditorBox)this.box()).commands(LanguageCommands.class).save(language, LanguageProperty.Description, this.model.description(), this.username());
    }
}

