/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.KeyPressEvent;
import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.UserCommands;
import io.quassar.editor.box.ui.displays.GoogleLoginDisplay;
import io.quassar.editor.box.ui.displays.templates.AbstractLoginTemplate;
import io.quassar.editor.box.ui.displays.templates.LoginSelectorOption;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.box.util.UrlHelper;
import io.quassar.editor.model.User;

public class LoginTemplate
extends AbstractLoginTemplate<EditorBox> {
    private String selectedUser;

    public LoginTemplate(EditorBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.initLoginUsingUsername();
        this.refresh();
    }

    public void refresh() {
        super.refresh();
        this.refreshGoogleLoginBlock();
        this.refreshLocalLoginBlock();
    }

    private void refreshGoogleLoginBlock() {
        this.googleLoginBlock.visible(!((EditorBox)this.box()).configuration().googleClientId().isEmpty());
        if (!this.googleLoginBlock.isVisible()) {
            return;
        }
        if (this.googleLoginStamp.display() == null) {
            this.createLoginDisplay();
        }
        this.googleLoginStamp.refresh();
    }

    private void createLoginDisplay() {
        GoogleLoginDisplay display = new GoogleLoginDisplay((EditorBox)this.box());
        display.onSuccess(this::login);
        display.onFailure(e -> this.notifyUser(this.translate("Could not login using Google"), UserMessage.Type.Error));
        this.googleLoginStamp.display(display);
    }

    private void refreshLocalLoginBlock() {
        this.localLoginBlock.visible(UrlHelper.isLocalUrl(this.session().browser().requestUrl()));
        if (!this.localLoginBlock.isVisible()) {
            return;
        }
        this.userSelector.clear();
        ((EditorBox)this.box()).userManager().users().forEach(u -> this.userSelector.add(this.optionDisplayFor((User)u)));
        this.userSelector.children().stream().filter(d -> d instanceof LoginSelectorOption).forEach(Display::refresh);
    }

    private LoginSelectorOption optionDisplayFor(User user) {
        return new LoginSelectorOption((EditorBox)this.box()).user(user).onRemove(e -> this.removeUser(user));
    }

    private void removeUser(User user) {
        ((EditorBox)this.box()).userManager().remove(user);
        this.refresh();
    }

    private void initLoginUsingUsername() {
        this.userSelector.onSelect(this::updateSelectedUser);
        this.usernameField.onEnterPress(this::updateSelectedUser);
        this.login.onExecute(this::loginUsingUsername);
    }

    private void loginUsingUsername(Event event) {
        if (this.selectedUser == null) {
            this.selectedUser = this.usernameField.value();
        }
        this.login(this.selectedUser);
    }

    private void updateSelectedUser(SelectionEvent event) {
        String selected = !event.selection().isEmpty() ? (String)event.selection().getFirst() : null;
        LoginSelectorOption display = this.userSelector.children().stream().filter(d -> d instanceof LoginSelectorOption && d.name().equals(selected)).map(d -> (LoginSelectorOption)((Object)d)).findFirst().orElse(null);
        this.selectedUser = display != null ? display.username() : null;
    }

    private void updateSelectedUser(KeyPressEvent event) {
        this.selectedUser = this.usernameField.value();
        this.login(this.selectedUser);
    }

    private void login(String username) {
        this.login(new io.intino.alexandria.ui.services.push.User().username(username).fullName(username).email(username));
    }

    private void login(io.intino.alexandria.ui.services.push.User userInfo) {
        User user = ((EditorBox)this.box()).userManager().get(userInfo.email());
        if (user == null) {
            user = ((EditorBox)this.box()).commands(UserCommands.class).create(userInfo.email(), this.username());
        }
        this.session().user(userInfo);
        ((TemplateNotifier)this.notifier).redirect(this.redirectUrl(user));
    }

    private String redirectUrl(User user) {
        String url = this.session().preference("callback");
        if (url != null && !url.isEmpty()) {
            return url;
        }
        return PathHelper.homeUrl(this.session());
    }
}

