/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.commands.LanguageCommands;
import io.quassar.editor.box.commands.ModelCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguageKitTemplate;
import io.quassar.editor.box.ui.displays.templates.DependencyTemplate;
import io.quassar.editor.box.ui.displays.templates.DownloadTemplate;
import io.quassar.editor.box.ui.displays.templates.ModelsTemplate;
import io.quassar.editor.box.ui.types.LanguageTab;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import java.io.File;
import java.util.function.Consumer;

public class LanguageKitTemplate
extends AbstractLanguageKitTemplate<EditorBox> {
    private Language language;
    private String release;
    private Consumer<Command.CommandResult> createVersionListener;

    public LanguageKitTemplate(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void release(String release) {
        this.release = release;
    }

    public void onCreateVersion(Consumer<Command.CommandResult> listener) {
        this.createVersionListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.createVersion.onExecute(e -> this.createVersion());
        this.createTemplate.onExecute(e -> this.createTemplate());
        this.modelsCatalog.onCreateModel(e -> this.createModel());
    }

    public void refresh() {
        super.refresh();
        this.selectVersionBlock.visible(this.release == null);
        this.versionBlock.visible(this.release != null && this.release() != null);
        this.versionNotCreatedBlock.visible(this.release != null && this.release() == null);
        if (!this.versionBlock.isVisible()) {
            return;
        }
        this.refreshMetamodel();
        this.refreshDownloads();
        this.refreshMavenDependencies();
        this.refreshTemplate();
        this.refreshExamples();
    }

    private void refreshMetamodel() {
        Model metamodel = ((EditorBox)this.box()).modelManager().get(this.language.metamodel());
        this.metamodelLink.title(ModelHelper.label(metamodel, this.language(), (EditorBox)this.box()));
        this.metamodelLink.site(PathHelper.modelUrl(metamodel, this.release, this.session()));
    }

    private void refreshDownloads() {
        File graphFile = ((EditorBox)this.box()).languageManager().loadGraph(this.language, this.release());
        this.downloadsBlock.visible(graphFile != null);
        if (!this.downloadsBlock.isVisible()) {
            return;
        }
        this.downloads.clear();
        this.fill(graphFile, (DownloadTemplate)this.downloads.add());
    }

    private void refreshMavenDependencies() {
        this.dependencies.clear();
        ((EditorBox)this.box()).languageManager().loadReaders(this.language, this.release()).forEach(r -> this.fill((File)r, (DependencyTemplate)this.dependencies.add()));
    }

    private void refreshTemplate() {
        String templateId = this.release().template();
        Model template = templateId != null ? ((EditorBox)this.box()).modelManager().get(templateId) : null;
        this.templateDefined.visible(template != null);
        this.templateNotDefined.visible(template == null);
        if (template == null) {
            return;
        }
        this.templateLink.title(ModelHelper.label(template, this.language(), (EditorBox)this.box()));
        this.templateLink.site(PathHelper.modelUrl(template, "draft", this.session()));
        this.templateCreateDate.value(template.createDate());
    }

    private void refreshExamples() {
        this.modelsCatalog.language(this.language);
        this.modelsCatalog.mode(ModelsTemplate.Mode.Forge);
        this.modelsCatalog.release(this.release());
        this.modelsCatalog.tab(LanguageTab.Examples);
        this.modelsCatalog.refresh();
    }

    private void fill(File file, DownloadTemplate display) {
        display.language(this.language);
        display.release(this.release);
        display.file(file);
        display.refresh();
    }

    private void fill(File file, DependencyTemplate display) {
        display.language(this.language);
        display.release(this.release);
        display.file(file);
        display.refresh();
    }

    private void createVersion() {
        this.notifyUser("Creating version...", UserMessage.Type.Loading);
        this.createVersion.readonly(true);
        this.createVersionListener.accept(((EditorBox)this.box()).commands(LanguageCommands.class).createRelease(this.language, this.release, this.username()));
        this.createVersion.readonly(false);
        this.hideUserNotification();
    }

    private LanguageRelease release() {
        return this.language.release(this.release);
    }

    private void createTemplate() {
        ((EditorBox)this.box()).commands(ModelCommands.class).createTemplate(this.language, this.release(), this.username());
        this.refreshTemplate();
    }

    private Model createModel() {
        Model result = ((EditorBox)this.box()).commands(ModelCommands.class).createExample(this.language, this.release(), this.username());
        this.refreshExamples();
        return result;
    }
}

