/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.actions;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.Forbidden;
import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.actions.QuassarAction;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.model.Model;
import java.io.InputStream;

public class GetDownloadModelFileAction
extends QuassarAction {
    public String model;
    public String release;
    public String file;

    public Resource execute() throws Forbidden {
        Model quassarModel = this.box.modelManager().get(this.model);
        if (quassarModel == null) {
            Logger.error((String)"Model %s not found".formatted(this.model));
            return DisplayHelper.emptyFile();
        }
        if (!this.check(quassarModel)) {
            throw new Forbidden("You dont have access to download this model release");
        }
        try {
            InputStream content = this.box.modelManager().content(quassarModel, this.release, this.file);
            return new Resource(this.file, content);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return DisplayHelper.emptyFile();
        }
    }
}

