/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.actions;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.Forbidden;
import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.actions.QuassarAction;
import io.quassar.editor.box.util.ArchetypeHelper;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.ZipHelper;
import io.quassar.editor.model.Model;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class GetDownloadModelAction
extends QuassarAction {
    public String model;
    public String release;

    public Resource execute() throws Forbidden {
        Model quassarModel = this.box.modelManager().get(this.model);
        if (quassarModel == null) {
            Logger.error((String)"Model %s not found".formatted(this.model));
            return DisplayHelper.emptyFile();
        }
        if (!this.check(quassarModel)) {
            throw new Forbidden("You dont have access to download this model release");
        }
        try {
            File workspace = this.box.archetype().models().workspace(ArchetypeHelper.relativeModelPath(this.model), this.model);
            File result = new File(this.box.archetype().tmp().root(), "%s-%s.zip".formatted(ModelHelper.label(quassarModel, "en", this.box), this.release));
            ZipHelper.zip(workspace.toPath(), result.toPath());
            return new Resource(result.getName(), (InputStream)new FileInputStream(result));
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return DisplayHelper.emptyFile();
        }
    }
}

