/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.actions;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.exceptions.Forbidden;
import io.intino.alexandria.http.server.AlexandriaHttpContext;
import io.intino.alexandria.rest.RequestErrorHandler;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.util.ArtifactoryHelper;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import java.io.File;

public class GetArtifactoryFileAction
implements RequestErrorHandler {
    public EditorBox box;
    public AlexandriaHttpContext context;

    public Resource execute() throws Forbidden {
        GavCoordinates coordinates = ArtifactoryHelper.parse(this.pathInfo());
        if (coordinates == null) {
            throw new Forbidden("Repository file not found");
        }
        String extension = this.fileExtension();
        Language language = this.locateLanguage(coordinates);
        boolean isJar = extension.equals(".jar");
        boolean isManifest = extension.equals(".pom");
        LanguageRelease release = language.release(coordinates.version());
        if (coordinates.artifactId().equals("graph")) {
            return isJar ? new Resource(this.box.languageManager().loadGraph(language, release)) : GetArtifactoryFileAction.emptyManifest();
        }
        boolean isDsl = coordinates.artifactId().equals(language.name());
        return isDsl ? this.loadDsl(language, release, isManifest) : this.loadReader(language, release, coordinates.artifactId(), isManifest);
    }

    private Language locateLanguage(GavCoordinates coordinates) {
        Language language = this.box.languageManager().get(coordinates);
        if (language == null) {
            language = this.box.languageManager().get(Language.nameFrom(coordinates.groupId()));
        }
        return language;
    }

    private Resource loadDsl(Language language, LanguageRelease release, boolean isManifest) {
        if (isManifest) {
            File result = this.box.languageManager().loadDslManifest(language, release);
            return result != null ? new Resource(result) : GetArtifactoryFileAction.emptyManifest();
        }
        return new Resource(this.box.languageManager().loadDsl(language, release));
    }

    private Resource loadReader(Language language, LanguageRelease release, String artifactId, boolean isManifest) {
        String file = ArtifactoryHelper.readerNameFrom(artifactId);
        if (isManifest) {
            return new Resource(this.box.languageManager().loadReaderManifest(language, release, file));
        }
        return new Resource(this.box.languageManager().loadReader(language, release, file));
    }

    private String fileExtension() {
        return this.pathInfo().substring(this.pathInfo().lastIndexOf("."));
    }

    private String pathInfo() {
        String pathInfo = (String)this.context.get((Object)"pathInfo");
        String defaultPath = "/releases";
        return pathInfo.substring(pathInfo.indexOf(defaultPath) + defaultPath.length() + 1);
    }

    public void onMalformedRequest(Throwable e) throws AlexandriaException {
        throw new BadRequest("Malformed request");
    }

    private static Resource emptyManifest() {
        return new Resource("pom.xml", new byte[0]);
    }
}

