package io.provista.shared;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

import static java.lang.Integer.parseInt;
import static java.lang.Long.parseLong;

public class OCR {
	private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMM");

	public static long id(String ocr) {
		return (parseRPU(ocr) << 22) + (parseMonths(ocr) << 11) + (parseTipo(ocr) << 4) + parseDigito(ocr);
	}

	public static String get(long id) {
		return String.format("%012d", rpu(id)) + date(id).format(formatter) + tipo(id) + digito(id);
	}

	public static long rpu(long id) {
		return id >> 22;
	}

	public static LocalDate date(long id) {
		int months = (int) ((id >> 11) & 0x7FF);
		return LocalDate.of(1900 + months / 12, (months%12)+1, 1);
	}

	public static String tipo(long id) {
		return String.format("%02d", (int) ((id >> 4) & 0x7F));
	}

	public static int digito(long id) {
		return (int) (id & 0xF);
	}

	private static long parseRPU(String ocr) {
		return parseLong(ocr.substring(0, 12));
	}

	private static long parseMonths(String ocr) {
		return isNullDate(ocr) ? 0L : parseYear(ocr) * 12L + parseMonth(ocr) - 1;
	}

	private static boolean isNullDate(String ocr) {
		return ocr.startsWith("000000", 12);
	}

	private static int parseMonth(String ocr) {
		int month = parseInt(ocr.substring(16, 18));
		return month <=12 ? month : 0;
	}

	private static int parseYear(String ocr) {
		return bound(parseInt(ocr.substring(12, 16)) - 1900);
	}

	private static int bound(int value) {
		return value <= 1000 ? Math.max(value, 0) : 1000;
	}

	private static long parseTipo(String ocr) {
		return parseInt(ocr.substring(18, 20));
	}

	private static int parseDigito(String ocr) {
		return parseInt(ocr.substring(20, 21));
	}
}
