package io.provista.shared;

import java.util.ArrayList;
import java.util.List;

public class Historial implements java.io.Serializable {
	public enum Estado {SinEstado, Activo, Baja, Cortado, Desconectado, SujetoACorte, CortadoAroCand, Temporal, BajaSinMedidorRet, CorteMufaPoste, BajaEnProceso}

	public enum Giro {Gobierno, Privado}

	public enum Tipo {Suministro, Fotovoltaica, NetMetering, NetBilling, VentaTotal}

	public enum TipoPersona {Fisica, Moral}

	public enum Cobranza {Normal, Centralizada, Domiciliada, Recurrente}

	private long rpu = 0L;
	private Estado estado;
	private Giro giro;
	private Tipo tipo;
	private String rfc;
	private String nombre;
	private TipoPersona tipoPersona;
	private Cobranza cobranza;
	private String alias;
	private String division;
	private String agencia;
	private String ciclo;
	private String cuenta;
	private boolean esPuntoVenta = false;
	private List<String> paperLess = new ArrayList<>();
	private MediosContacto mediosContacto;
	private Direccion direccion;
	private Suministro suministro;
	private Generacion generacion;
	private java.util.List<Adeudo> adeudo = new java.util.ArrayList<>();
	private long credito = 0;

	public long rpu() {
		return this.rpu;
	}

	public Estado estado() {
		return estado;
	}

	public Giro giro() {
		return giro;
	}

	public Tipo tipo() {
		return tipo;
	}

	public String rfc() {
		return this.rfc;
	}

	public String nombre() {
		return this.nombre;
	}

	public TipoPersona tipoPersona() {
		return tipoPersona;
	}

	public Cobranza cobranza() {
		return cobranza;
	}

	public String alias() {
		return this.alias;
	}

	public String division() {
		return this.division;
	}

	public String agencia() {
		return this.agencia;
	}

	public String ciclo() {
		return this.ciclo;
	}

	public String cuenta() {
		return this.cuenta;
	}

	public boolean esPuntoVenta() {
		return this.esPuntoVenta;
	}

	public long credito() {
		return this.credito;
	}

	public List<String> paperLess() {
		return this.paperLess;
	}

	public MediosContacto mediosContacto() {
		return this.mediosContacto;
	}

	public Direccion direccion() {
		return this.direccion;
	}

	public Suministro suministro() {
		return this.suministro;
	}

	public Generacion generacion() {
		return this.generacion;
	}

	public java.util.List<Adeudo> adeudoList() {
		return this.adeudo;
	}

	public java.util.List<Adeudo> adeudoList(java.util.function.Predicate<Adeudo> predicate) {
		return this.adeudo.stream().filter(predicate).collect(java.util.stream.Collectors.toList());
	}

	public Adeudo adeudo(java.util.function.Predicate<Adeudo> predicate) {
		return this.adeudo.stream().filter(predicate).findFirst().orElse(null);
	}

	public Historial rpu(long rpu) {
		this.rpu = rpu;
		return this;
	}

	public Historial estado(Estado estado) {
		this.estado = estado;
		return this;
	}

	public Historial giro(Giro giro) {
		this.giro = giro;
		return this;
	}

	public Historial tipo(Tipo tipo) {
		this.tipo = tipo;
		return this;
	}

	public Historial rfc(String rfc) {
		this.rfc = rfc;
		return this;
	}

	public Historial nombre(String nombre) {
		this.nombre = nombre;
		return this;
	}

	public Historial tipoPersona(TipoPersona tipoPersona) {
		this.tipoPersona = tipoPersona;
		return this;
	}

	public Historial cobranza(Cobranza cobranza) {
		this.cobranza = cobranza;
		return this;
	}

	public Historial alias(String alias) {
		this.alias = alias;
		return this;
	}

	public Historial division(String division) {
		this.division = division;
		return this;
	}

	public Historial agencia(String agencia) {
		this.agencia = agencia;
		return this;
	}

	public Historial ciclo(String ciclo) {
		this.ciclo = ciclo;
		return this;
	}

	public Historial cuenta(String cuenta) {
		this.cuenta = cuenta;
		return this;
	}

	public Historial esPuntoVenta(boolean esPuntoVenta) {
		this.esPuntoVenta = esPuntoVenta;
		return this;
	}

	public Historial credito(long importe) {
		this.credito = importe;
		return this;
	}

	public Historial paperLess(List<String> paperLess) {
		this.paperLess = paperLess;
		return this;
	}

	public Historial mediosContacto(MediosContacto mediosContacto) {
		this.mediosContacto = mediosContacto;
		return this;
	}

	public Historial direccion(Direccion direccion) {
		this.direccion = direccion;
		return this;
	}

	public Historial suministro(Suministro suministro) {
		this.suministro = suministro;
		return this;
	}

	public Historial generacion(Generacion generacion) {
		this.generacion = generacion;
		return this;
	}

	public Historial adeudoList(java.util.List<Adeudo> adeudo) {
		this.adeudo = adeudo;
		return this;
	}

	public static class MediosContacto implements java.io.Serializable {

		private java.util.List<String> emails = new java.util.ArrayList<>();
		private java.util.List<String> telefonos = new java.util.ArrayList<>();

		public java.util.List<String> emails() {
			return this.emails;
		}

		public java.util.List<String> telefonos() {
			return this.telefonos;
		}

		public MediosContacto emails(java.util.List<String> emails) {
			this.emails = emails;
			return this;
		}

		public MediosContacto telefonos(java.util.List<String> telefonos) {
			this.telefonos = telefonos;
			return this;
		}
	}

	public static class Direccion implements java.io.Serializable {

		private String calle;
		private String numero;
		private String numeroInterior;
		private String colonia;
		private String localidad;
		private String municipio;
		private String estado;
		private String pais;
		private String codigoPostal;

		public String calle() {
			return this.calle;
		}

		public String numero() {
			return this.numero;
		}

		public String numeroInterior() {
			return this.numeroInterior;
		}

		public String colonia() {
			return this.colonia;
		}

		public String localidad() {
			return this.localidad;
		}

		public String municipio() {
			return this.municipio;
		}

		public String estado() {
			return this.estado;
		}

		public String pais() {
			return this.pais;
		}

		public String codigoPostal() {
			return this.codigoPostal;
		}

		public Direccion calle(String calle) {
			this.calle = calle;
			return this;
		}

		public Direccion numero(String numero) {
			this.numero = numero;
			return this;
		}

		public Direccion numeroInterior(String numeroInterior) {
			this.numeroInterior = numeroInterior;
			return this;
		}

		public Direccion colonia(String colonia) {
			this.colonia = colonia;
			return this;
		}

		public Direccion localidad(String localidad) {
			this.localidad = localidad;
			return this;
		}

		public Direccion municipio(String municipio) {
			this.municipio = municipio;
			return this;
		}

		public Direccion estado(String estado) {
			this.estado = estado;
			return this;
		}

		public Direccion pais(String pais) {
			this.pais = pais;
			return this;
		}

		public Direccion codigoPostal(String codigoPostal) {
			this.codigoPostal = codigoPostal;
			return this;
		}
	}

	public static class Suministro implements java.io.Serializable {
		public enum PeriodoVerano {FebJul, MarAgo, AbrSep, MayOct}

		public enum GiroCFE {IndustrialAgropecuaria, IndustrialExtractiva, IndustrialTransformacion, IndustrialMinera, IndustrialConstruccion, IndustrialEnergia, Comercial, Transporte, Residencial, GobiernoFederal, GobiernoEstatal, GobiernoMunicipal, Servicios, SectorParaestatal, Otros}

		public enum TipoFacturacion {Mensual, Bimestral, Tetramestral, SoloTemporal, CicloEspecial}

		public enum TipoContrato {Normal, UsoPropio, UltimoRecurso, Empleado}

		private TipoContrato tipoContrato;
		private TipoFacturacion tipoFacturacion;
		private String tarifa;
		private boolean tarifaDAC = false;
		private String tarifaAutogestion;
		private String scian;
		private GiroCFE giroCFE;
		private PeriodoVerano periodoVerano;
		private Instalacion instalacion;
		private Localizacion localizacion;

		public TipoContrato tipoContrato() {
			return tipoContrato;
		}

		public TipoFacturacion tipoFacturacion() {
			return tipoFacturacion;
		}

		public String tarifa() {
			return this.tarifa;
		}

		public boolean tarifaDAC() {
			return this.tarifaDAC;
		}

		public String tarifaAutogestion() {
			return this.tarifaAutogestion;
		}

		public String scian() {
			return this.scian;
		}

		public GiroCFE giroCFE() {
			return giroCFE;
		}

		public PeriodoVerano periodoVerano() {
			return periodoVerano;
		}


		public Instalacion instalacion() {
			return this.instalacion;
		}

		public Localizacion localizacion() {
			return this.localizacion;
		}

		public Suministro tipoContrato(TipoContrato tipoContrato) {
			this.tipoContrato = tipoContrato;
			return this;
		}

		public Suministro tipoFacturacion(TipoFacturacion tipoFacturacion) {
			this.tipoFacturacion = tipoFacturacion;
			return this;
		}

		public Suministro tarifa(String tarifa) {
			this.tarifa = tarifa;
			return this;
		}

		public Suministro tarifaDAC(boolean tarifaDAC) {
			this.tarifaDAC = tarifaDAC;
			return this;
		}

		public Suministro tarifaAutogestion(String tarifaAutogestion) {
			this.tarifaAutogestion = tarifaAutogestion;
			return this;
		}

		public Suministro scian(String scian) {
			this.scian = scian;
			return this;
		}

		public Suministro giroCFE(GiroCFE giroCFE) {
			this.giroCFE = giroCFE;
			return this;
		}

		public Suministro periodoVerano(PeriodoVerano periodoVerano) {
			this.periodoVerano = periodoVerano;
			return this;
		}

		public Suministro instalacion(Instalacion instalacion) {
			this.instalacion = instalacion;
			return this;
		}

		public Suministro localizacion(Localizacion localizacion) {
			this.localizacion = localizacion;
			return this;
		}

		public static class Instalacion implements java.io.Serializable {
			public enum TipoSuministro {AltaMediaTensionPrimario, AltaMediaTensionSecundario, BajaTensionSecundario, BajaTensionPrimario}

			private double potenciaContratada = 0.0;
			private double potenciaInstalada = 0.0;
			private int hilos = 0;
			private TipoSuministro tipoSuministro;


			public double potenciaContratada() {
				return this.potenciaContratada;
			}

			public double potenciaInstalada() {
				return this.potenciaInstalada;
			}

			public int hilos() {
				return this.hilos;
			}

			public TipoSuministro tipoSuministro() {
				return tipoSuministro;
			}

			public Instalacion potenciaContratada(double potenciaContratada) {
				this.potenciaContratada = potenciaContratada;
				return this;
			}

			public Instalacion potenciaInstalada(double potenciaInstalada) {
				this.potenciaInstalada = potenciaInstalada;
				return this;
			}

			public Instalacion hilos(int hilos) {
				this.hilos = hilos;
				return this;
			}

			public Instalacion tipoSuministro(TipoSuministro tipoSuministro) {
				this.tipoSuministro = tipoSuministro;
				return this;
			}
		}

		public static class Localizacion implements java.io.Serializable {
			public enum Region {BajaCalifornia, BajaCaliforniaSur, Central, Noreste, Noroeste, Norte, Sur, Peninsular}

			private String direccion;
			private java.util.List<String> callesAdyacentes = new java.util.ArrayList<>();
			private String colonia;
			private String municipio;
			private Region region;
			private String estado;
			private String codigoPostal;
			private String coordenadas;

			public String direccion() {
				return this.direccion;
			}

			public java.util.List<String> callesAdyacentes() {
				return this.callesAdyacentes;
			}

			public String colonia() {
				return this.colonia;
			}

			public String municipio() {
				return this.municipio;
			}

			public Region region() {
				return region;
			}

			public String estado() {
				return this.estado;
			}

			public String codigoPostal() {
				return this.codigoPostal;
			}

			public String coordenadas() {
				return this.coordenadas;
			}

			public Localizacion direccion(String direccion) {
				this.direccion = direccion;
				return this;
			}

			public Localizacion callesAdyacentes(java.util.List<String> callesAdyacentes) {
				this.callesAdyacentes = callesAdyacentes;
				return this;
			}

			public Localizacion colonia(String colonia) {
				this.colonia = colonia;
				return this;
			}

			public Localizacion municipio(String municipio) {
				this.municipio = municipio;
				return this;
			}

			public Localizacion region(Region region) {
				this.region = region;
				return this;
			}

			public Localizacion estado(String estado) {
				this.estado = estado;
				return this;
			}

			public Localizacion codigoPostal(String codigoPostal) {
				this.codigoPostal = codigoPostal;
				return this;
			}

			public Localizacion coordenadas(String coordenadas) {
				this.coordenadas = coordenadas;
				return this;
			}
		}
	}

	public static class Generacion implements java.io.Serializable {

		private String rmu;
		private TipoContrato tipoContrato;

		public enum TipoContrato {
			Fotovoltaica, NetBilling, NetMetering, VentaTotal
		}

		private java.time.Instant fechaAlta;
		private double facturacionEstimada = 0.0;
		private String codigoSolicitudInterconexion;
		private Instalacion instalacion;
		private Localizacion localizacion;

		public String rmu() {
			return this.rmu;
		}

		public TipoContrato tipoContrato() {
			return tipoContrato;
		}

		public java.time.Instant fechaAlta() {
			return this.fechaAlta;
		}

		public double facturacionEstimada() {
			return this.facturacionEstimada;
		}

		public String codigoSolicitudInterconexion() {
			return this.codigoSolicitudInterconexion;
		}

		public Instalacion instalacion() {
			return this.instalacion;
		}

		public Localizacion localizacion() {
			return this.localizacion;
		}

		public Generacion rmu(String rmu) {
			this.rmu = rmu;
			return this;
		}

		public Generacion tipoContrato(TipoContrato tipoContrato) {
			this.tipoContrato = tipoContrato;
			return this;
		}

		public Generacion fechaAlta(java.time.Instant fechaAlta) {
			this.fechaAlta = fechaAlta;
			return this;
		}

		public Generacion facturacionEstimada(double facturacionEstimada) {
			this.facturacionEstimada = facturacionEstimada;
			return this;
		}

		public Generacion codigoSolicitudInterconexion(String codigoSolicitudInterconexion) {
			this.codigoSolicitudInterconexion = codigoSolicitudInterconexion;
			return this;
		}

		public Generacion instalacion(Instalacion instalacion) {
			this.instalacion = instalacion;
			return this;
		}

		public Generacion localizacion(Localizacion localizacion) {
			this.localizacion = localizacion;
			return this;
		}

		public static class Instalacion implements java.io.Serializable {

			private java.time.Instant fechaInstalacion;
			private int unidadesGeneracion = 0;
			private double potenciaInstalada = 0.0;
			private String tension;
			private String tecnologia;
			private java.util.List<String> medidores = new java.util.ArrayList<>();

			public java.time.Instant fechaInstalacion() {
				return this.fechaInstalacion;
			}

			public int unidadesGeneracion() {
				return this.unidadesGeneracion;
			}

			public double potenciaInstalada() {
				return this.potenciaInstalada;
			}

			public String tension() {
				return this.tension;
			}

			public String tecnologia() {
				return this.tecnologia;
			}

			public java.util.List<String> medidores() {
				return this.medidores;
			}

			public Instalacion fechaInstalacion(java.time.Instant fechaInstalacion) {
				this.fechaInstalacion = fechaInstalacion;
				return this;
			}

			public Instalacion unidadesGeneracion(int unidadesGeneracion) {
				this.unidadesGeneracion = unidadesGeneracion;
				return this;
			}

			public Instalacion potenciaInstalada(double potenciaInstalada) {
				this.potenciaInstalada = potenciaInstalada;
				return this;
			}

			public Instalacion tension(String tension) {
				this.tension = tension;
				return this;
			}

			public Instalacion tecnologia(String tecnologia) {
				this.tecnologia = tecnologia;
				return this;
			}

			public Instalacion medidores(java.util.List<String> medidores) {
				this.medidores = medidores;
				return this;
			}
		}

		public static class Localizacion implements java.io.Serializable {

			private String zona;
			private String zonaCarga;
			private String sistema;
			private String coordenadas;

			public String zona() {
				return this.zona;
			}

			public String zonaCarga() {
				return this.zonaCarga;
			}

			public String sistema() {
				return this.sistema;
			}

			public String coordenadas() {
				return this.coordenadas;
			}

			public Localizacion zona(String zona) {
				this.zona = zona;
				return this;
			}

			public Localizacion zonaCarga(String zonaCarga) {
				this.zonaCarga = zonaCarga;
				return this;
			}

			public Localizacion sistema(String sistema) {
				this.sistema = sistema;
				return this;
			}

			public Localizacion coordenadas(String coordenadas) {
				this.coordenadas = coordenadas;
				return this;
			}
		}
	}

	public static class Adeudo implements java.io.Serializable {
		public enum Estado {
			Pendiente, Pagado, Cancelado, ProcesoCobro, Invalido
		}

		private String ocr;
		private String division;
		private String fecha;
		private String fechaVencimiento;
		private String desde;
		private String hasta;
		private Estado estado;
		private long importe = 0L;
		private long lectura = 0L;
		private int diasFacturados = 0;
		private String serie;
		private long folio;
		private boolean esDocumentado = false;
		private ConceptoEnergia conceptoEnergia;
		private java.util.List<ConceptoAdicional> conceptoAdicional = new java.util.ArrayList<>();
		private java.util.List<Pago> pagos = new java.util.ArrayList<>();

		public String ocr() {
			return this.ocr;
		}

		public String division() {
			return this.division;
		}

		public String fecha() {
			return this.fecha;
		}

		public String periodo() {
			return this.fecha.substring(0, 6);
		}

		public String fechaVencimiento() {
			return this.fechaVencimiento;
		}

		public String desde() {
			return this.desde;
		}

		public String hasta() {
			return this.hasta;
		}

		public Estado estado() {
			return estado;
		}

		public long importe() {
			return this.importe;
		}

		public long lectura() {
			return this.lectura;
		}

		public int diasFacturados() {
			return this.diasFacturados;
		}

		public String serie() {
			return this.serie;
		}

		public long folio() {
			return this.folio;
		}

		public boolean esDocumentado() {
			return this.esDocumentado;
		}

		public ConceptoEnergia conceptoEnergia() {
			return this.conceptoEnergia;
		}

		public java.util.List<ConceptoAdicional> conceptoAdicionalList() {
			return this.conceptoAdicional;
		}

		public java.util.List<ConceptoAdicional> conceptoAdicionalList(java.util.function.Predicate<ConceptoAdicional> predicate) {
			return this.conceptoAdicional.stream().filter(predicate).collect(java.util.stream.Collectors.toList());
		}

		public ConceptoAdicional conceptoAdicional(java.util.function.Predicate<ConceptoAdicional> predicate) {
			return this.conceptoAdicional.stream().filter(predicate).findFirst().orElse(null);
		}

		public java.util.List<Pago> pagos() {
			return this.pagos;
		}

		public java.util.List<Pago> pagos(java.util.function.Predicate<Pago> predicate) {
			return this.pagos.stream().filter(predicate).collect(java.util.stream.Collectors.toList());
		}

		public Pago pago(java.util.function.Predicate<Pago> predicate) {
			return this.pagos.stream().filter(predicate).findFirst().orElse(null);
		}

		public Adeudo ocr(String ocr) {
			this.ocr = ocr;
			return this;
		}

		public Adeudo division(String division) {
			this.division = division;
			return this;
		}

		public Adeudo fecha(String fecha) {
			this.fecha = fecha;
			return this;
		}

		public Adeudo fechaVencimiento(String fechaVencimiento) {
			this.fechaVencimiento = fechaVencimiento;
			return this;
		}

		public Adeudo desde(String desde) {
			this.desde = desde;
			return this;
		}

		public Adeudo hasta(String hasta) {
			this.hasta = hasta;
			return this;
		}

		public Adeudo estado(Estado estado) {
			this.estado = estado;
			return this;
		}

		public Adeudo importe(long importe) {
			this.importe = importe;
			return this;
		}

		public Adeudo lectura(long lectura) {
			this.lectura = lectura;
			return this;
		}

		public Adeudo diasFacturados(int diasFacturados) {
			this.diasFacturados = diasFacturados;
			return this;
		}

		public Adeudo serie(String serie) {
			this.serie = serie;
			return this;
		}

		public Adeudo folio(long folio) {
			this.folio = folio;
			return this;
		}

		public Adeudo esDocumentado(boolean esDocumentado) {
			this.esDocumentado = esDocumentado;
			return this;
		}

		public Adeudo conceptoEnergia(ConceptoEnergia conceptoEnergia) {
			this.conceptoEnergia = conceptoEnergia;
			return this;
		}

		public Adeudo conceptoAdicionalList(java.util.List<ConceptoAdicional> conceptoAdicional) {
			this.conceptoAdicional = conceptoAdicional;
			return this;
		}

		public Adeudo pagos(java.util.List<Pago> pagos) {
			this.pagos = pagos;
			return this;
		}

		public static class ConceptoEnergia implements java.io.Serializable {
			private String tarifa;
			private long kwh = 0L;
			private long importe = 0L;
			private long iva = 0L;
			private long dap = 0L;

			public String tarifa() {
				return this.tarifa;
			}

			public long kwh() {
				return this.kwh;
			}

			public long importe() {
				return this.importe;
			}

			public long iva() {
				return this.iva;
			}

			public long dap() {
				return this.dap;
			}

			public ConceptoEnergia tarifa(String tarifa) {
				this.tarifa = tarifa;
				return this;
			}

			public ConceptoEnergia kwh(long kwh) {
				this.kwh = kwh;
				return this;
			}

			public ConceptoEnergia importe(long importe) {
				this.importe = importe;
				return this;
			}

			public ConceptoEnergia iva(long iva) {
				this.iva = iva;
				return this;
			}

			public ConceptoEnergia dap(long dap) {
				this.dap = dap;
				return this;
			}
		}

		public static class ConceptoAdicional implements java.io.Serializable {

			private String concepto;
			private long importe = 0L;
			private long iva = 0L;
			private long dap = 0L;

			public String concepto() {
				return this.concepto;
			}

			public long importe() {
				return this.importe;
			}

			public long iva() {
				return this.iva;
			}

			public long dap() {
				return this.dap;
			}

			public ConceptoAdicional concepto(String concepto) {
				this.concepto = concepto;
				return this;
			}

			public ConceptoAdicional importe(long importe) {
				this.importe = importe;
				return this;
			}

			public ConceptoAdicional iva(long iva) {
				this.iva = iva;
				return this;
			}

			public ConceptoAdicional dap(long dap) {
				this.dap = dap;
				return this;
			}
		}
	}

	public static class Pago implements java.io.Serializable {
		private boolean parcial = false;
		private String fecha;
		private long importe = 0L;
		private String modoPago;
		private String canalPago;
		private String transactionId;
		private String autorizacion;
		private String serie;
		private long folio;

		public boolean parcial() {
			return this.parcial;
		}

		public String fecha() {
			return this.fecha;
		}

		public long importe() {
			return this.importe;
		}

		public String modoPago() {
			return this.modoPago;
		}

		public String canalPago() {
			return this.canalPago;
		}

		public Pago parcial(boolean parcial) {
			this.parcial = parcial;
			return this;
		}

		public Pago fecha(String fecha) {
			this.fecha = fecha;
			return this;
		}

		public Pago importe(long importe) {
			this.importe = importe;
			return this;
		}

		public Pago modoPago(String modoPago) {
			this.modoPago = modoPago;
			return this;
		}

		public Pago canalPago(String canalPago) {
			this.canalPago = canalPago;
			return this;
		}

		public String transactionId() {
			return transactionId;
		}

		public Pago transactionId(String transactionId) {
			this.transactionId = transactionId;
			return this;
		}

		public String autorizacion() {
			return autorizacion;
		}

		public Pago autorizacion(String autorizacion) {
			this.autorizacion = autorizacion;
			return this;
		}

		public String serie() {
			return serie;
		}

		public Pago serie(String serie) {
			this.serie = serie;
			return this;
		}

		public long folio() {
			return folio;
		}

		public Pago folio(long folio) {
			this.folio = folio;
			return this;
		}
	}
}