package io.provista.datahub.transaction.comercial;

import io.provista.datahub.dimension.*;

public class Movimiento extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 15;

	public Movimiento() {
		super(defaultByteStore());
	}

	public Movimiento(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("rpu", rpu());
		values.put("importe", importe());
		values.put("agencia", agencia());
		values.put("origen", origen());
		values.put("claseMovimiento", claseMovimiento());
		return values;
	}

	protected long id() {
		return rpu();
	}

	public long rpu() {
		return bitBuffer.getAlignedLong(0);
	}

	public long importe() {
		return bitBuffer.getLongNBits(64, 40);
	}

	public Agencia.Category agencia() {
		final int value = bitBuffer.getIntegerNBits(104, 10);
		return Agencia.categoryByIndex(value);
	}

	public OrigenMovimiento.Category origen() {
		final short value = bitBuffer.getShortNBits(114, 2);
		return OrigenMovimiento.categoryByIndex(value);
	}

	public ClaseMovimiento.Category claseMovimiento() {
		final short value = bitBuffer.getShortNBits(116, 2);
		return ClaseMovimiento.categoryByIndex(value);
	}

	public Movimiento rpu(long rpu) {
		bitBuffer.setAlignedLong(0, rpu);
		return this;
	}

	public Movimiento importe(long importe) {
		bitBuffer.setLongNBits(64, 40, importe);
		return this;
	}

	public Movimiento agencia(String agencia) {
		bitBuffer.setIntegerNBits(104, 10, agencia == null ? (int) NULL : Agencia.categoryByName(agencia).index);
		return this;
	}

	public Movimiento agencia(Agencia.Category agencia) {
		bitBuffer.setIntegerNBits(104, 10, agencia == null ? (int) NULL : agencia.index);
		return this;
	}

	public Movimiento origen(String origen) {
		bitBuffer.setIntegerNBits(114, 2, origen == null ? (int) NULL : OrigenMovimiento.categoryByName(origen).index);
		return this;
	}

	public Movimiento origen(OrigenMovimiento.Category origen) {
		bitBuffer.setIntegerNBits(114, 2, origen == null ? (int) NULL : origen.index);
		return this;
	}

	public Movimiento claseMovimiento(String claseMovimiento) {
		bitBuffer.setIntegerNBits(116, 2, claseMovimiento == null ? (int) NULL : ClaseMovimiento.categoryByName(claseMovimiento).index);
		return this;
	}

	public Movimiento claseMovimiento(ClaseMovimiento.Category claseMovimiento) {
		bitBuffer.setIntegerNBits(116, 2, claseMovimiento == null ? (int) NULL : claseMovimiento.index);
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}