package io.provista.datahub.transaction;

import io.provista.datahub.dimension.*;

public class VentaPendienteCobro extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 52;

	public VentaPendienteCobro() {
		super(defaultByteStore());
	}

	public VentaPendienteCobro(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("importeTotal", importeTotal());
		values.put("importe", importe());
		values.put("importeNeto", importeNeto());
		values.put("kwh", kwh());
		values.put("ocr", ocr());
		values.put("dap", dap());
		values.put("iva", iva());
		values.put("diasDesdeFacturacion", diasDesdeFacturacion());
		values.put("claseCartera", claseCartera());
		values.put("claseGestion", claseGestion());
		values.put("concepto", concepto());
		return values;
	}

	protected long id() {
		return ocr();
	}

	public long importeTotal() {
		return bitBuffer.getAlignedLong(0);
	}

	public long importe() {
		return bitBuffer.getAlignedLong(64);
	}

	public long importeNeto() {
		return bitBuffer.getAlignedLong(128);
	}

	public long kwh() {
		return bitBuffer.getLongNBits(192, 64);
	}

	public long ocr() {
		return bitBuffer.getAlignedLong(256);
	}

	public long dap() {
		return bitBuffer.getLongNBits(320, 32);
	}

	public long iva() {
		return bitBuffer.getLongNBits(352, 32);
	}

	public int diasDesdeFacturacion() {
		return bitBuffer.getIntegerNBits(384, 16);
	}

	public ClaseCartera.Category claseCartera() {
		final short value = bitBuffer.getShortNBits(400, 3);
		return ClaseCartera.categoryByIndex(value);
	}

	public ClaseGestion.Category claseGestion() {
		final short value = bitBuffer.getShortNBits(403, 2);
		return ClaseGestion.categoryByIndex(value);
	}

	public ConceptoVenta.Category concepto() {
		final int value = bitBuffer.getIntegerNBits(405, 7);
		return ConceptoVenta.categoryByIndex(value);
	}

	public VentaPendienteCobro importeTotal(long importeTotal) {
		bitBuffer.setAlignedLong(0, importeTotal);
		return this;
	}

	public VentaPendienteCobro importe(long importe) {
		bitBuffer.setAlignedLong(64, importe);
		return this;
	}

	public VentaPendienteCobro importeNeto(long importeNeto) {
		bitBuffer.setAlignedLong(128, importeNeto);
		return this;
	}

	public VentaPendienteCobro kwh(long kwh) {
		bitBuffer.setLongNBits(192, 64, kwh);
		return this;
	}

	public VentaPendienteCobro ocr(long ocr) {
		bitBuffer.setAlignedLong(256, ocr);
		return this;
	}

	public VentaPendienteCobro dap(long dap) {
		bitBuffer.setLongNBits(320, 32, dap);
		return this;
	}

	public VentaPendienteCobro iva(long iva) {
		bitBuffer.setLongNBits(352, 32, iva);
		return this;
	}

	public VentaPendienteCobro diasDesdeFacturacion(int diasDesdeFacturacion) {
		bitBuffer.setIntegerNBits(384, 16, diasDesdeFacturacion);
		return this;
	}

	public VentaPendienteCobro claseCartera(String claseCartera) {
		bitBuffer.setIntegerNBits(400, 3, claseCartera == null ? (int) NULL : ClaseCartera.categoryByName(claseCartera).index);
		return this;
	}

	public VentaPendienteCobro claseCartera(ClaseCartera.Category claseCartera) {
		bitBuffer.setIntegerNBits(400, 3, claseCartera == null ? (int) NULL : claseCartera.index);
		return this;
	}

	public VentaPendienteCobro claseGestion(String claseGestion) {
		bitBuffer.setIntegerNBits(403, 2, claseGestion == null ? (int) NULL : ClaseGestion.categoryByName(claseGestion).index);
		return this;
	}

	public VentaPendienteCobro claseGestion(ClaseGestion.Category claseGestion) {
		bitBuffer.setIntegerNBits(403, 2, claseGestion == null ? (int) NULL : claseGestion.index);
		return this;
	}

	public VentaPendienteCobro concepto(String concepto) {
		bitBuffer.setIntegerNBits(405, 7, concepto == null ? (int) NULL : ConceptoVenta.categoryByName(concepto).index);
		return this;
	}

	public VentaPendienteCobro concepto(ConceptoVenta.Category concepto) {
		bitBuffer.setIntegerNBits(405, 7, concepto == null ? (int) NULL : concepto.index);
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}