package io.provista.datahub.transaction;

import io.provista.datahub.dimension.*;

public class VentaEnergiaDetallada extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 14;

	public VentaEnergiaDetallada() {
		super(defaultByteStore());
	}

	public VentaEnergiaDetallada(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("ocr", ocr());
		values.put("importe", importe());
		values.put("concepto", concepto());
		return values;
	}

	protected long id() {
		return ocr();
	}

	public long ocr() {
		return bitBuffer.getAlignedLong(0);
	}

	public long importe() {
		return bitBuffer.getLongNBits(64, 40);
	}

	public ConceptoEnergia.Category concepto() {
		final short value = bitBuffer.getShortNBits(104, 3);
		return ConceptoEnergia.categoryByIndex(value);
	}

	public VentaEnergiaDetallada ocr(long ocr) {
		bitBuffer.setAlignedLong(0, ocr);
		return this;
	}

	public VentaEnergiaDetallada importe(long importe) {
		bitBuffer.setLongNBits(64, 40, importe);
		return this;
	}

	public VentaEnergiaDetallada concepto(String concepto) {
		bitBuffer.setIntegerNBits(104, 3, concepto == null ? (int) NULL : ConceptoEnergia.categoryByName(concepto).index);
		return this;
	}

	public VentaEnergiaDetallada concepto(ConceptoEnergia.Category concepto) {
		bitBuffer.setIntegerNBits(104, 3, concepto == null ? (int) NULL : concepto.index);
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}