package io.provista.datahub.transaction;

import io.provista.datahub.dimension.*;

public class VentaEnergia extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 53;

	public VentaEnergia() {
		super(defaultByteStore());
	}

	public VentaEnergia(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("total", total());
		values.put("dap", dap());
		values.put("iva", iva());
		values.put("importe", importe());
		values.put("kwh", kwh());
		values.put("ocr", ocr());
		values.put("diasFacturados", diasFacturados());
		values.put("estado", estado());
		values.put("claseVenta", claseVenta());
		values.put("concepto", concepto());
		return values;
	}

	protected long id() {
		return ocr();
	}

	public long total() {
		return bitBuffer.getAlignedLong(0);
	}

	public long dap() {
		return bitBuffer.getAlignedLong(64);
	}

	public long iva() {
		return bitBuffer.getAlignedLong(128);
	}

	public long importe() {
		return bitBuffer.getLongNBits(192, 64);
	}

	public long kwh() {
		return bitBuffer.getAlignedLong(256);
	}

	public long ocr() {
		return bitBuffer.getLongNBits(320, 64);
	}

	public int diasFacturados() {
		return bitBuffer.getIntegerNBits(384, 16);
	}

	public EstadoAdeudo.Category estado() {
		final short value = bitBuffer.getShortNBits(400, 3);
		return EstadoAdeudo.categoryByIndex(value);
	}

	public Tarifa.Category claseVenta() {
		final int value = bitBuffer.getIntegerNBits(403, 8);
		return Tarifa.categoryByIndex(value);
	}

	public ConceptoVenta.Category concepto() {
		final int value = bitBuffer.getIntegerNBits(411, 7);
		return ConceptoVenta.categoryByIndex(value);
	}

	public VentaEnergia total(long total) {
		bitBuffer.setAlignedLong(0, total);
		return this;
	}

	public VentaEnergia dap(long dap) {
		bitBuffer.setAlignedLong(64, dap);
		return this;
	}

	public VentaEnergia iva(long iva) {
		bitBuffer.setAlignedLong(128, iva);
		return this;
	}

	public VentaEnergia importe(long importe) {
		bitBuffer.setLongNBits(192, 64, importe);
		return this;
	}

	public VentaEnergia kwh(long kwh) {
		bitBuffer.setAlignedLong(256, kwh);
		return this;
	}

	public VentaEnergia ocr(long ocr) {
		bitBuffer.setLongNBits(320, 64, ocr);
		return this;
	}

	public VentaEnergia diasFacturados(int diasFacturados) {
		bitBuffer.setIntegerNBits(384, 16, diasFacturados);
		return this;
	}

	public VentaEnergia estado(String estado) {
		bitBuffer.setIntegerNBits(400, 3, estado == null ? (int) NULL : EstadoAdeudo.categoryByName(estado).index);
		return this;
	}

	public VentaEnergia estado(EstadoAdeudo.Category estado) {
		bitBuffer.setIntegerNBits(400, 3, estado == null ? (int) NULL : estado.index);
		return this;
	}

	public VentaEnergia claseVenta(String claseVenta) {
		bitBuffer.setIntegerNBits(403, 8, claseVenta == null ? (int) NULL : Tarifa.categoryByName(claseVenta).index);
		return this;
	}

	public VentaEnergia claseVenta(Tarifa.Category claseVenta) {
		bitBuffer.setIntegerNBits(403, 8, claseVenta == null ? (int) NULL : claseVenta.index);
		return this;
	}

	public VentaEnergia concepto(String concepto) {
		bitBuffer.setIntegerNBits(411, 7, concepto == null ? (int) NULL : ConceptoVenta.categoryByName(concepto).index);
		return this;
	}

	public VentaEnergia concepto(ConceptoVenta.Category concepto) {
		bitBuffer.setIntegerNBits(411, 7, concepto == null ? (int) NULL : concepto.index);
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}