package io.provista.datahub.transaction;

import io.provista.datahub.dimension.*;

public class VentaAdicional extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 24;

	public VentaAdicional() {
		super(defaultByteStore());
	}

	public VentaAdicional(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("ocr", ocr());
		values.put("dap", dap());
		values.put("iva", iva());
		values.put("importe", importe());
		values.put("concepto", concepto());
		return values;
	}

	protected long id() {
		return ocr();
	}

	public long ocr() {
		return bitBuffer.getAlignedLong(0);
	}

	public long dap() {
		return bitBuffer.getLongNBits(64, 40);
	}

	public long iva() {
		return bitBuffer.getLongNBits(104, 40);
	}

	public long importe() {
		return bitBuffer.getLongNBits(144, 40);
	}

	public ConceptoVenta.Category concepto() {
		final int value = bitBuffer.getIntegerNBits(184, 7);
		return ConceptoVenta.categoryByIndex(value);
	}

	public VentaAdicional ocr(long ocr) {
		bitBuffer.setAlignedLong(0, ocr);
		return this;
	}

	public VentaAdicional dap(long dap) {
		bitBuffer.setLongNBits(64, 40, dap);
		return this;
	}

	public VentaAdicional iva(long iva) {
		bitBuffer.setLongNBits(104, 40, iva);
		return this;
	}

	public VentaAdicional importe(long importe) {
		bitBuffer.setLongNBits(144, 40, importe);
		return this;
	}

	public VentaAdicional concepto(String concepto) {
		bitBuffer.setIntegerNBits(184, 7, concepto == null ? (int) NULL : ConceptoVenta.categoryByName(concepto).index);
		return this;
	}

	public VentaAdicional concepto(ConceptoVenta.Category concepto) {
		bitBuffer.setIntegerNBits(184, 7, concepto == null ? (int) NULL : concepto.index);
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}