package io.provista.datahub.transaction;

import io.provista.datahub.dimension.*;

public class UsoEmpleado extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 52;

	public UsoEmpleado() {
		super(defaultByteStore());
	}

	public UsoEmpleado(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("total", total());
		values.put("dap", dap());
		values.put("iva", iva());
		values.put("importe", importe());
		values.put("kwh", kwh());
		values.put("ocr", ocr());
		values.put("diasFacturados", diasFacturados());
		values.put("concepto", concepto());
		values.put("esExcedente", esExcedente());
		return values;
	}

	protected long id() {
		return ocr();
	}

	public long total() {
		return bitBuffer.getAlignedLong(0);
	}

	public long dap() {
		return bitBuffer.getAlignedLong(64);
	}

	public long iva() {
		return bitBuffer.getAlignedLong(128);
	}

	public long importe() {
		return bitBuffer.getLongNBits(192, 64);
	}

	public long kwh() {
		return bitBuffer.getAlignedLong(256);
	}

	public long ocr() {
		return bitBuffer.getLongNBits(320, 64);
	}

	public int diasFacturados() {
		return bitBuffer.getIntegerNBits(384, 16);
	}

	public ConceptoVenta.Category concepto() {
		final int value = bitBuffer.getIntegerNBits(400, 7);
		return ConceptoVenta.categoryByIndex(value);
	}

	public Boolean esExcedente() {
		byte value = bitBuffer.getByteNBits(407, 2);
		return value == NULL ? null : value == 2;
	}

	public UsoEmpleado total(long total) {
		bitBuffer.setAlignedLong(0, total);
		return this;
	}

	public UsoEmpleado dap(long dap) {
		bitBuffer.setAlignedLong(64, dap);
		return this;
	}

	public UsoEmpleado iva(long iva) {
		bitBuffer.setAlignedLong(128, iva);
		return this;
	}

	public UsoEmpleado importe(long importe) {
		bitBuffer.setLongNBits(192, 64, importe);
		return this;
	}

	public UsoEmpleado kwh(long kwh) {
		bitBuffer.setAlignedLong(256, kwh);
		return this;
	}

	public UsoEmpleado ocr(long ocr) {
		bitBuffer.setLongNBits(320, 64, ocr);
		return this;
	}

	public UsoEmpleado diasFacturados(int diasFacturados) {
		bitBuffer.setIntegerNBits(384, 16, diasFacturados);
		return this;
	}

	public UsoEmpleado concepto(String concepto) {
		bitBuffer.setIntegerNBits(400, 7, concepto == null ? (int) NULL : ConceptoVenta.categoryByName(concepto).index);
		return this;
	}

	public UsoEmpleado concepto(ConceptoVenta.Category concepto) {
		bitBuffer.setIntegerNBits(400, 7, concepto == null ? (int) NULL : concepto.index);
		return this;
	}

	public UsoEmpleado esExcedente(boolean esExcedente) {
		bitBuffer.setByteNBits(407, 2, (byte) (esExcedente ? 2 : 1));
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}