package io.provista.datahub.transaction;

import io.provista.datahub.dimension.*;

public class MetricaVentaEnergia extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 15;

	public MetricaVentaEnergia() {
		super(defaultByteStore());
	}

	public MetricaVentaEnergia(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("rpu", rpu());
		values.put("consumoMensual", consumoMensual());
		values.put("morosidad", morosidad());
		return values;
	}

	protected long id() {
		return rpu();
	}

	public long rpu() {
		return bitBuffer.getAlignedLong(0);
	}

	public long consumoMensual() {
		return bitBuffer.getLongNBits(64, 40);
	}

	public int morosidad() {
		return bitBuffer.getIntegerNBits(104, 16);
	}

	public MetricaVentaEnergia rpu(long rpu) {
		bitBuffer.setAlignedLong(0, rpu);
		return this;
	}

	public MetricaVentaEnergia consumoMensual(long consumoMensual) {
		bitBuffer.setLongNBits(64, 40, consumoMensual);
		return this;
	}

	public MetricaVentaEnergia morosidad(int morosidad) {
		bitBuffer.setIntegerNBits(104, 16, morosidad);
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}