package io.provista.datahub.transaction;

import io.provista.datahub.dimension.*;

public class MetricaVentaAdicional extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 9;

	public MetricaVentaAdicional() {
		super(defaultByteStore());
	}

	public MetricaVentaAdicional(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("rpu", rpu());
		values.put("demandaContratada", demandaContratada());
		values.put("conCargoHorario", conCargoHorario());
		values.put("conMedicionDemanda", conMedicionDemanda());
		return values;
	}

	protected long id() {
		return rpu();
	}

	public long rpu() {
		return bitBuffer.getAlignedLong(0);
	}

	public ClaseDemandaContratada.Category demandaContratada() {
		final short value = bitBuffer.getShortNBits(64, 2);
		return ClaseDemandaContratada.categoryByIndex(value);
	}

	public Boolean conCargoHorario() {
		byte value = bitBuffer.getByteNBits(66, 2);
		return value == NULL ? null : value == 2;
	}

	public Boolean conMedicionDemanda() {
		byte value = bitBuffer.getByteNBits(68, 2);
		return value == NULL ? null : value == 2;
	}

	public MetricaVentaAdicional rpu(long rpu) {
		bitBuffer.setAlignedLong(0, rpu);
		return this;
	}

	public MetricaVentaAdicional demandaContratada(String demandaContratada) {
		bitBuffer.setIntegerNBits(64, 2, demandaContratada == null ? (int) NULL : ClaseDemandaContratada.categoryByName(demandaContratada).index);
		return this;
	}

	public MetricaVentaAdicional demandaContratada(ClaseDemandaContratada.Category demandaContratada) {
		bitBuffer.setIntegerNBits(64, 2, demandaContratada == null ? (int) NULL : demandaContratada.index);
		return this;
	}

	public MetricaVentaAdicional conCargoHorario(boolean conCargoHorario) {
		bitBuffer.setByteNBits(66, 2, (byte) (conCargoHorario ? 2 : 1));
		return this;
	}

	public MetricaVentaAdicional conMedicionDemanda(boolean conMedicionDemanda) {
		bitBuffer.setByteNBits(68, 2, (byte) (conMedicionDemanda ? 2 : 1));
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}