package io.provista.datahub.transaction;

import io.provista.datahub.dimension.*;

public class GastoEnergia extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 37;

	public GastoEnergia() {
		super(defaultByteStore());
	}

	public GastoEnergia(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("ocr", ocr());
		values.put("total", total());
		values.put("dap", dap());
		values.put("iva", iva());
		values.put("importe", importe());
		values.put("kwh", kwh());
		values.put("diasFacturados", diasFacturados());
		values.put("claseGasto", claseGasto());
		values.put("concepto", concepto());
		return values;
	}

	protected long id() {
		return ocr();
	}

	public long ocr() {
		return bitBuffer.getAlignedLong(0);
	}

	public long total() {
		return bitBuffer.getLongNBits(64, 40);
	}

	public long dap() {
		return bitBuffer.getLongNBits(104, 40);
	}

	public long iva() {
		return bitBuffer.getLongNBits(144, 40);
	}

	public long importe() {
		return bitBuffer.getLongNBits(184, 40);
	}

	public long kwh() {
		return bitBuffer.getLongNBits(224, 40);
	}

	public int diasFacturados() {
		return bitBuffer.getIntegerNBits(264, 16);
	}

	public ClaseGasto.Category claseGasto() {
		final short value = bitBuffer.getShortNBits(280, 2);
		return ClaseGasto.categoryByIndex(value);
	}

	public ConceptoVenta.Category concepto() {
		final int value = bitBuffer.getIntegerNBits(282, 7);
		return ConceptoVenta.categoryByIndex(value);
	}

	public GastoEnergia ocr(long ocr) {
		bitBuffer.setAlignedLong(0, ocr);
		return this;
	}

	public GastoEnergia total(long total) {
		bitBuffer.setLongNBits(64, 40, total);
		return this;
	}

	public GastoEnergia dap(long dap) {
		bitBuffer.setLongNBits(104, 40, dap);
		return this;
	}

	public GastoEnergia iva(long iva) {
		bitBuffer.setLongNBits(144, 40, iva);
		return this;
	}

	public GastoEnergia importe(long importe) {
		bitBuffer.setLongNBits(184, 40, importe);
		return this;
	}

	public GastoEnergia kwh(long kwh) {
		bitBuffer.setLongNBits(224, 40, kwh);
		return this;
	}

	public GastoEnergia diasFacturados(int diasFacturados) {
		bitBuffer.setIntegerNBits(264, 16, diasFacturados);
		return this;
	}

	public GastoEnergia claseGasto(String claseGasto) {
		bitBuffer.setIntegerNBits(280, 2, claseGasto == null ? (int) NULL : ClaseGasto.categoryByName(claseGasto).index);
		return this;
	}

	public GastoEnergia claseGasto(ClaseGasto.Category claseGasto) {
		bitBuffer.setIntegerNBits(280, 2, claseGasto == null ? (int) NULL : claseGasto.index);
		return this;
	}

	public GastoEnergia concepto(String concepto) {
		bitBuffer.setIntegerNBits(282, 7, concepto == null ? (int) NULL : ConceptoVenta.categoryByName(concepto).index);
		return this;
	}

	public GastoEnergia concepto(ConceptoVenta.Category concepto) {
		bitBuffer.setIntegerNBits(282, 7, concepto == null ? (int) NULL : concepto.index);
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}