package io.provista.datahub.transaction;

import io.provista.datahub.dimension.*;

public class GastoAdicional extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 25;

	public GastoAdicional() {
		super(defaultByteStore());
	}

	public GastoAdicional(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("ocr", ocr());
		values.put("dap", dap());
		values.put("iva", iva());
		values.put("importe", importe());
		values.put("claseGasto", claseGasto());
		values.put("concepto", concepto());
		return values;
	}

	protected long id() {
		return ocr();
	}

	public long ocr() {
		return bitBuffer.getAlignedLong(0);
	}

	public long dap() {
		return bitBuffer.getLongNBits(64, 40);
	}

	public long iva() {
		return bitBuffer.getLongNBits(104, 40);
	}

	public long importe() {
		return bitBuffer.getLongNBits(144, 40);
	}

	public ClaseGasto.Category claseGasto() {
		final short value = bitBuffer.getShortNBits(184, 2);
		return ClaseGasto.categoryByIndex(value);
	}

	public ConceptoVenta.Category concepto() {
		final int value = bitBuffer.getIntegerNBits(186, 7);
		return ConceptoVenta.categoryByIndex(value);
	}

	public GastoAdicional ocr(long ocr) {
		bitBuffer.setAlignedLong(0, ocr);
		return this;
	}

	public GastoAdicional dap(long dap) {
		bitBuffer.setLongNBits(64, 40, dap);
		return this;
	}

	public GastoAdicional iva(long iva) {
		bitBuffer.setLongNBits(104, 40, iva);
		return this;
	}

	public GastoAdicional importe(long importe) {
		bitBuffer.setLongNBits(144, 40, importe);
		return this;
	}

	public GastoAdicional claseGasto(String claseGasto) {
		bitBuffer.setIntegerNBits(184, 2, claseGasto == null ? (int) NULL : ClaseGasto.categoryByName(claseGasto).index);
		return this;
	}

	public GastoAdicional claseGasto(ClaseGasto.Category claseGasto) {
		bitBuffer.setIntegerNBits(184, 2, claseGasto == null ? (int) NULL : claseGasto.index);
		return this;
	}

	public GastoAdicional concepto(String concepto) {
		bitBuffer.setIntegerNBits(186, 7, concepto == null ? (int) NULL : ConceptoVenta.categoryByName(concepto).index);
		return this;
	}

	public GastoAdicional concepto(ConceptoVenta.Category concepto) {
		bitBuffer.setIntegerNBits(186, 7, concepto == null ? (int) NULL : concepto.index);
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}