package io.provista.datahub.transaction;

import io.provista.datahub.dimension.*;

public class EstadisticaSap extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 36;

	public EstadisticaSap() {
		super(defaultByteStore());
	}

	public EstadisticaSap(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("usuariosR3", usuariosR3());
		values.put("kwh", kwh());
		values.put("importe", importe());
		values.put("code", code());
		values.put("tipoFacturacion", tipoFacturacion());
		values.put("origen", origen());
		values.put("agencia", agencia());
		values.put("cuenta", cuenta());
		return values;
	}

	protected long id() {
		return code();
	}

	public long usuariosR3() {
		return bitBuffer.getAlignedLong(0);
	}

	public long kwh() {
		return bitBuffer.getAlignedLong(64);
	}

	public long importe() {
		return bitBuffer.getAlignedLong(128);
	}

	public long code() {
		return bitBuffer.getLongNBits(192, 64);
	}

	public TipoFacturacionSap.Category tipoFacturacion() {
		final short value = bitBuffer.getShortNBits(256, 2);
		return TipoFacturacionSap.categoryByIndex(value);
	}

	public OrigenSap.Category origen() {
		final short value = bitBuffer.getShortNBits(258, 2);
		return OrigenSap.categoryByIndex(value);
	}

	public AgenciaSap.Category agencia() {
		final int value = bitBuffer.getIntegerNBits(260, 10);
		return AgenciaSap.categoryByIndex(value);
	}

	public CuentaEstadistica.Category cuenta() {
		final int value = bitBuffer.getIntegerNBits(270, 13);
		return CuentaEstadistica.categoryByIndex(value);
	}

	public EstadisticaSap usuariosR3(long usuariosR3) {
		bitBuffer.setAlignedLong(0, usuariosR3);
		return this;
	}

	public EstadisticaSap kwh(long kwh) {
		bitBuffer.setAlignedLong(64, kwh);
		return this;
	}

	public EstadisticaSap importe(long importe) {
		bitBuffer.setAlignedLong(128, importe);
		return this;
	}

	public EstadisticaSap code(long code) {
		bitBuffer.setLongNBits(192, 64, code);
		return this;
	}

	public EstadisticaSap tipoFacturacion(String tipoFacturacion) {
		bitBuffer.setIntegerNBits(256, 2, tipoFacturacion == null ? (int) NULL : TipoFacturacionSap.categoryByName(tipoFacturacion).index);
		return this;
	}

	public EstadisticaSap tipoFacturacion(TipoFacturacionSap.Category tipoFacturacion) {
		bitBuffer.setIntegerNBits(256, 2, tipoFacturacion == null ? (int) NULL : tipoFacturacion.index);
		return this;
	}

	public EstadisticaSap origen(String origen) {
		bitBuffer.setIntegerNBits(258, 2, origen == null ? (int) NULL : OrigenSap.categoryByName(origen).index);
		return this;
	}

	public EstadisticaSap origen(OrigenSap.Category origen) {
		bitBuffer.setIntegerNBits(258, 2, origen == null ? (int) NULL : origen.index);
		return this;
	}

	public EstadisticaSap agencia(String agencia) {
		bitBuffer.setIntegerNBits(260, 10, agencia == null ? (int) NULL : AgenciaSap.categoryByName(agencia).index);
		return this;
	}

	public EstadisticaSap agencia(AgenciaSap.Category agencia) {
		bitBuffer.setIntegerNBits(260, 10, agencia == null ? (int) NULL : agencia.index);
		return this;
	}

	public EstadisticaSap cuenta(String cuenta) {
		bitBuffer.setIntegerNBits(270, 13, cuenta == null ? (int) NULL : CuentaEstadistica.categoryByName(cuenta).index);
		return this;
	}

	public EstadisticaSap cuenta(CuentaEstadistica.Category cuenta) {
		bitBuffer.setIntegerNBits(270, 13, cuenta == null ? (int) NULL : cuenta.index);
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}