package io.provista.datahub.transaction;

import io.provista.datahub.dimension.*;

public class DiscrepanciaConsumo extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 30;

	public DiscrepanciaConsumo() {
		super(defaultByteStore());
	}

	public DiscrepanciaConsumo(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("rpu", rpu());
		values.put("importeDis", importeDis());
		values.put("cantidadDis", cantidadDis());
		values.put("importe", importe());
		values.put("cantidad", cantidad());
		values.put("tarifa", tarifa());
		values.put("periodo", periodo());
		values.put("clase", clase());
		return values;
	}

	protected long id() {
		return rpu();
	}

	public long rpu() {
		return bitBuffer.getAlignedLong(0);
	}

	public long importeDis() {
		return bitBuffer.getLongNBits(64, 40);
	}

	public long cantidadDis() {
		return bitBuffer.getLongNBits(104, 40);
	}

	public long importe() {
		return bitBuffer.getLongNBits(144, 40);
	}

	public long cantidad() {
		return bitBuffer.getLongNBits(184, 40);
	}

	public Tarifa.Category tarifa() {
		final int value = bitBuffer.getIntegerNBits(224, 8);
		return Tarifa.categoryByIndex(value);
	}

	public ClasePeriodo.Category periodo() {
		final short value = bitBuffer.getShortNBits(232, 3);
		return ClasePeriodo.categoryByIndex(value);
	}

	public ClaseConsumo.Category clase() {
		final short value = bitBuffer.getShortNBits(235, 2);
		return ClaseConsumo.categoryByIndex(value);
	}

	public DiscrepanciaConsumo rpu(long rpu) {
		bitBuffer.setAlignedLong(0, rpu);
		return this;
	}

	public DiscrepanciaConsumo importeDis(long importeDis) {
		bitBuffer.setLongNBits(64, 40, importeDis);
		return this;
	}

	public DiscrepanciaConsumo cantidadDis(long cantidadDis) {
		bitBuffer.setLongNBits(104, 40, cantidadDis);
		return this;
	}

	public DiscrepanciaConsumo importe(long importe) {
		bitBuffer.setLongNBits(144, 40, importe);
		return this;
	}

	public DiscrepanciaConsumo cantidad(long cantidad) {
		bitBuffer.setLongNBits(184, 40, cantidad);
		return this;
	}

	public DiscrepanciaConsumo tarifa(String tarifa) {
		bitBuffer.setIntegerNBits(224, 8, tarifa == null ? (int) NULL : Tarifa.categoryByName(tarifa).index);
		return this;
	}

	public DiscrepanciaConsumo tarifa(Tarifa.Category tarifa) {
		bitBuffer.setIntegerNBits(224, 8, tarifa == null ? (int) NULL : tarifa.index);
		return this;
	}

	public DiscrepanciaConsumo periodo(String periodo) {
		bitBuffer.setIntegerNBits(232, 3, periodo == null ? (int) NULL : ClasePeriodo.categoryByName(periodo).index);
		return this;
	}

	public DiscrepanciaConsumo periodo(ClasePeriodo.Category periodo) {
		bitBuffer.setIntegerNBits(232, 3, periodo == null ? (int) NULL : periodo.index);
		return this;
	}

	public DiscrepanciaConsumo clase(String clase) {
		bitBuffer.setIntegerNBits(235, 2, clase == null ? (int) NULL : ClaseConsumo.categoryByName(clase).index);
		return this;
	}

	public DiscrepanciaConsumo clase(ClaseConsumo.Category clase) {
		bitBuffer.setIntegerNBits(235, 2, clase == null ? (int) NULL : clase.index);
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}