package io.provista.datahub.transaction;

import io.provista.datahub.dimension.*;

public class ContratoAnalizado extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 50;

	public ContratoAnalizado() {
		super(defaultByteStore());
	}

	public ContratoAnalizado(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("cpd", cpd());
		values.put("rpu", rpu());
		values.put("cargaInstalada", cargaInstalada());
		values.put("demandaContratada", demandaContratada());
		values.put("codigoPostal", codigoPostal());
		values.put("fechaBaja", fechaBaja());
		values.put("fechaAlta", fechaAlta());
		values.put("folio", folio());
		values.put("indiceIngresos", indiceIngresos());
		values.put("indiceRentabilidad", indiceRentabilidad());
		values.put("indiceMorosidad", indiceMorosidad());
		values.put("verano", verano());
		values.put("tarifaReguladaSugerida", tarifaReguladaSugerida());
		values.put("tarifa", tarifa());
		values.put("facturacion", facturacion());
		values.put("segmentoComercial", segmentoComercial());
		values.put("segmentoSocioeconomico", segmentoSocioeconomico());
		values.put("suministradora", suministradora());
		values.put("claseCobranza", claseCobranza());
		values.put("claseSuministro", claseSuministro());
		values.put("claseEmpresa", claseEmpresa());
		values.put("claseCliente", claseCliente());
		values.put("claseGiro", claseGiro());
		values.put("clasePersona", clasePersona());
		values.put("numeroMedidores", numeroMedidores());
		values.put("hilos", hilos());
		values.put("ciclo", ciclo());
		values.put("region", region());
		values.put("poblacion", poblacion());
		values.put("colonia", colonia());
		values.put("ruta", ruta());
		values.put("agencia", agencia());
		values.put("medioContacto", medioContacto());
		values.put("status", status());
		return values;
	}

	protected long id() {
		return rpu();
	}

	public long cpd() {
		return bitBuffer.getAlignedLong(0);
	}

	public long rpu() {
		return bitBuffer.getAlignedLong(64);
	}

	public float cargaInstalada() {
		return bitBuffer.getAlignedReal32Bits(128);
	}

	public float demandaContratada() {
		return bitBuffer.getAlignedReal32Bits(160);
	}

	public int codigoPostal() {
		return bitBuffer.getIntegerNBits(192, 18);
	}

	public int fechaBaja() {
		return bitBuffer.getIntegerNBits(210, 16);
	}

	public int fechaAlta() {
		return bitBuffer.getIntegerNBits(226, 16);
	}

	public int folio() {
		return bitBuffer.getIntegerNBits(242, 14);
	}

	public int indiceIngresos() {
		return bitBuffer.getIntegerNBits(256, 8);
	}

	public int indiceRentabilidad() {
		return bitBuffer.getIntegerNBits(264, 8);
	}

	public int indiceMorosidad() {
		return bitBuffer.getIntegerNBits(272, 8);
	}

	public ClasePeriodoVerano.Category verano() {
		final short value = bitBuffer.getShortNBits(280, 3);
		return ClasePeriodoVerano.categoryByIndex(value);
	}

	public TarifaRegulada.Category tarifaReguladaSugerida() {
		final short value = bitBuffer.getShortNBits(283, 4);
		return TarifaRegulada.categoryByIndex(value);
	}

	public Tarifa.Category tarifa() {
		final int value = bitBuffer.getIntegerNBits(287, 8);
		return Tarifa.categoryByIndex(value);
	}

	public ClaseFacturacion.Category facturacion() {
		final short value = bitBuffer.getShortNBits(295, 3);
		return ClaseFacturacion.categoryByIndex(value);
	}

	public SegmentoComercial.Category segmentoComercial() {
		final short value = bitBuffer.getShortNBits(298, 4);
		return SegmentoComercial.categoryByIndex(value);
	}

	public SegmentoSocioeconomico.Category segmentoSocioeconomico() {
		final short value = bitBuffer.getShortNBits(302, 3);
		return SegmentoSocioeconomico.categoryByIndex(value);
	}

	public Suministradora.Category suministradora() {
		final short value = bitBuffer.getShortNBits(305, 4);
		return Suministradora.categoryByIndex(value);
	}

	public ClaseCobranza.Category claseCobranza() {
		final short value = bitBuffer.getShortNBits(309, 3);
		return ClaseCobranza.categoryByIndex(value);
	}

	public ClaseSuministro.Category claseSuministro() {
		final short value = bitBuffer.getShortNBits(312, 3);
		return ClaseSuministro.categoryByIndex(value);
	}

	public ClaseEmpresa.Category claseEmpresa() {
		final short value = bitBuffer.getShortNBits(315, 4);
		return ClaseEmpresa.categoryByIndex(value);
	}

	public ClaseCliente.Category claseCliente() {
		final short value = bitBuffer.getShortNBits(319, 3);
		return ClaseCliente.categoryByIndex(value);
	}

	public ClaseGiro.Category claseGiro() {
		final short value = bitBuffer.getShortNBits(322, 3);
		return ClaseGiro.categoryByIndex(value);
	}

	public ClaseRfc.Category clasePersona() {
		final short value = bitBuffer.getShortNBits(325, 2);
		return ClaseRfc.categoryByIndex(value);
	}

	public int numeroMedidores() {
		return bitBuffer.getIntegerNBits(327, 8);
	}

	public NumeroHilos.Category hilos() {
		final short value = bitBuffer.getShortNBits(335, 2);
		return NumeroHilos.categoryByIndex(value);
	}

	public Ciclo.Category ciclo() {
		final int value = bitBuffer.getIntegerNBits(337, 7);
		return Ciclo.categoryByIndex(value);
	}

	public Region.Category region() {
		final int value = bitBuffer.getIntegerNBits(344, 4);
		return Region.categoryByIndex(value);
	}

	public Poblacion.Category poblacion() {
		final int value = bitBuffer.getIntegerNBits(348, 7);
		return Poblacion.categoryByIndex(value);
	}

	public Colonia.Category colonia() {
		final int value = bitBuffer.getIntegerNBits(355, 17);
		return Colonia.categoryByIndex(value);
	}

	public Ruta.Category ruta() {
		final int value = bitBuffer.getIntegerNBits(372, 10);
		return Ruta.categoryByIndex(value);
	}

	public Agencia.Category agencia() {
		final int value = bitBuffer.getIntegerNBits(382, 10);
		return Agencia.categoryByIndex(value);
	}

	public MedioContacto.Category medioContacto() {
		final short value = bitBuffer.getShortNBits(392, 2);
		return MedioContacto.categoryByIndex(value);
	}

	public EstatusContrato.Category status() {
		final short value = bitBuffer.getShortNBits(394, 4);
		return EstatusContrato.categoryByIndex(value);
	}

	public ContratoAnalizado cpd(long cpd) {
		bitBuffer.setAlignedLong(0, cpd);
		return this;
	}

	public ContratoAnalizado rpu(long rpu) {
		bitBuffer.setAlignedLong(64, rpu);
		return this;
	}

	public ContratoAnalizado cargaInstalada(Float cargaInstalada) {
		bitBuffer.setAlignedReal32Bits(128, cargaInstalada);
		return this;
	}

	public ContratoAnalizado demandaContratada(Float demandaContratada) {
		bitBuffer.setAlignedReal32Bits(160, demandaContratada);
		return this;
	}

	public ContratoAnalizado codigoPostal(int codigoPostal) {
		bitBuffer.setIntegerNBits(192, 18, codigoPostal);
		return this;
	}

	public ContratoAnalizado fechaBaja(int fechaBaja) {
		bitBuffer.setIntegerNBits(210, 16, fechaBaja);
		return this;
	}

	public ContratoAnalizado fechaAlta(int fechaAlta) {
		bitBuffer.setIntegerNBits(226, 16, fechaAlta);
		return this;
	}

	public ContratoAnalizado folio(int folio) {
		bitBuffer.setIntegerNBits(242, 14, folio);
		return this;
	}

	public ContratoAnalizado indiceIngresos(int indiceIngresos) {
		bitBuffer.setIntegerNBits(256, 8, indiceIngresos);
		return this;
	}

	public ContratoAnalizado indiceRentabilidad(int indiceRentabilidad) {
		bitBuffer.setIntegerNBits(264, 8, indiceRentabilidad);
		return this;
	}

	public ContratoAnalizado indiceMorosidad(int indiceMorosidad) {
		bitBuffer.setIntegerNBits(272, 8, indiceMorosidad);
		return this;
	}

	public ContratoAnalizado verano(String verano) {
		bitBuffer.setIntegerNBits(280, 3, verano == null ? (int) NULL : ClasePeriodoVerano.categoryByName(verano).index);
		return this;
	}

	public ContratoAnalizado verano(ClasePeriodoVerano.Category verano) {
		bitBuffer.setIntegerNBits(280, 3, verano == null ? (int) NULL : verano.index);
		return this;
	}

	public ContratoAnalizado tarifaReguladaSugerida(String tarifaReguladaSugerida) {
		bitBuffer.setIntegerNBits(283, 4, tarifaReguladaSugerida == null ? (int) NULL : TarifaRegulada.categoryByName(tarifaReguladaSugerida).index);
		return this;
	}

	public ContratoAnalizado tarifaReguladaSugerida(TarifaRegulada.Category tarifaReguladaSugerida) {
		bitBuffer.setIntegerNBits(283, 4, tarifaReguladaSugerida == null ? (int) NULL : tarifaReguladaSugerida.index);
		return this;
	}

	public ContratoAnalizado tarifa(String tarifa) {
		bitBuffer.setIntegerNBits(287, 8, tarifa == null ? (int) NULL : Tarifa.categoryByName(tarifa).index);
		return this;
	}

	public ContratoAnalizado tarifa(Tarifa.Category tarifa) {
		bitBuffer.setIntegerNBits(287, 8, tarifa == null ? (int) NULL : tarifa.index);
		return this;
	}

	public ContratoAnalizado facturacion(String facturacion) {
		bitBuffer.setIntegerNBits(295, 3, facturacion == null ? (int) NULL : ClaseFacturacion.categoryByName(facturacion).index);
		return this;
	}

	public ContratoAnalizado facturacion(ClaseFacturacion.Category facturacion) {
		bitBuffer.setIntegerNBits(295, 3, facturacion == null ? (int) NULL : facturacion.index);
		return this;
	}

	public ContratoAnalizado segmentoComercial(String segmentoComercial) {
		bitBuffer.setIntegerNBits(298, 4, segmentoComercial == null ? (int) NULL : SegmentoComercial.categoryByName(segmentoComercial).index);
		return this;
	}

	public ContratoAnalizado segmentoComercial(SegmentoComercial.Category segmentoComercial) {
		bitBuffer.setIntegerNBits(298, 4, segmentoComercial == null ? (int) NULL : segmentoComercial.index);
		return this;
	}

	public ContratoAnalizado segmentoSocioeconomico(String segmentoSocioeconomico) {
		bitBuffer.setIntegerNBits(302, 3, segmentoSocioeconomico == null ? (int) NULL : SegmentoSocioeconomico.categoryByName(segmentoSocioeconomico).index);
		return this;
	}

	public ContratoAnalizado segmentoSocioeconomico(SegmentoSocioeconomico.Category segmentoSocioeconomico) {
		bitBuffer.setIntegerNBits(302, 3, segmentoSocioeconomico == null ? (int) NULL : segmentoSocioeconomico.index);
		return this;
	}

	public ContratoAnalizado suministradora(String suministradora) {
		bitBuffer.setIntegerNBits(305, 4, suministradora == null ? (int) NULL : Suministradora.categoryByName(suministradora).index);
		return this;
	}

	public ContratoAnalizado suministradora(Suministradora.Category suministradora) {
		bitBuffer.setIntegerNBits(305, 4, suministradora == null ? (int) NULL : suministradora.index);
		return this;
	}

	public ContratoAnalizado claseCobranza(String claseCobranza) {
		bitBuffer.setIntegerNBits(309, 3, claseCobranza == null ? (int) NULL : ClaseCobranza.categoryByName(claseCobranza).index);
		return this;
	}

	public ContratoAnalizado claseCobranza(ClaseCobranza.Category claseCobranza) {
		bitBuffer.setIntegerNBits(309, 3, claseCobranza == null ? (int) NULL : claseCobranza.index);
		return this;
	}

	public ContratoAnalizado claseSuministro(String claseSuministro) {
		bitBuffer.setIntegerNBits(312, 3, claseSuministro == null ? (int) NULL : ClaseSuministro.categoryByName(claseSuministro).index);
		return this;
	}

	public ContratoAnalizado claseSuministro(ClaseSuministro.Category claseSuministro) {
		bitBuffer.setIntegerNBits(312, 3, claseSuministro == null ? (int) NULL : claseSuministro.index);
		return this;
	}

	public ContratoAnalizado claseEmpresa(String claseEmpresa) {
		bitBuffer.setIntegerNBits(315, 4, claseEmpresa == null ? (int) NULL : ClaseEmpresa.categoryByName(claseEmpresa).index);
		return this;
	}

	public ContratoAnalizado claseEmpresa(ClaseEmpresa.Category claseEmpresa) {
		bitBuffer.setIntegerNBits(315, 4, claseEmpresa == null ? (int) NULL : claseEmpresa.index);
		return this;
	}

	public ContratoAnalizado claseCliente(String claseCliente) {
		bitBuffer.setIntegerNBits(319, 3, claseCliente == null ? (int) NULL : ClaseCliente.categoryByName(claseCliente).index);
		return this;
	}

	public ContratoAnalizado claseCliente(ClaseCliente.Category claseCliente) {
		bitBuffer.setIntegerNBits(319, 3, claseCliente == null ? (int) NULL : claseCliente.index);
		return this;
	}

	public ContratoAnalizado claseGiro(String claseGiro) {
		bitBuffer.setIntegerNBits(322, 3, claseGiro == null ? (int) NULL : ClaseGiro.categoryByName(claseGiro).index);
		return this;
	}

	public ContratoAnalizado claseGiro(ClaseGiro.Category claseGiro) {
		bitBuffer.setIntegerNBits(322, 3, claseGiro == null ? (int) NULL : claseGiro.index);
		return this;
	}

	public ContratoAnalizado clasePersona(String clasePersona) {
		bitBuffer.setIntegerNBits(325, 2, clasePersona == null ? (int) NULL : ClaseRfc.categoryByName(clasePersona).index);
		return this;
	}

	public ContratoAnalizado clasePersona(ClaseRfc.Category clasePersona) {
		bitBuffer.setIntegerNBits(325, 2, clasePersona == null ? (int) NULL : clasePersona.index);
		return this;
	}

	public ContratoAnalizado numeroMedidores(int numeroMedidores) {
		bitBuffer.setIntegerNBits(327, 8, numeroMedidores);
		return this;
	}

	public ContratoAnalizado hilos(String hilos) {
		bitBuffer.setIntegerNBits(335, 2, hilos == null ? (int) NULL : NumeroHilos.categoryByName(hilos).index);
		return this;
	}

	public ContratoAnalizado hilos(NumeroHilos.Category hilos) {
		bitBuffer.setIntegerNBits(335, 2, hilos == null ? (int) NULL : hilos.index);
		return this;
	}

	public ContratoAnalizado ciclo(String ciclo) {
		bitBuffer.setIntegerNBits(337, 7, ciclo == null ? (int) NULL : Ciclo.categoryByName(ciclo).index);
		return this;
	}

	public ContratoAnalizado ciclo(Ciclo.Category ciclo) {
		bitBuffer.setIntegerNBits(337, 7, ciclo == null ? (int) NULL : ciclo.index);
		return this;
	}

	public ContratoAnalizado region(String region) {
		bitBuffer.setIntegerNBits(344, 4, region == null ? (int) NULL : Region.categoryByName(region).index);
		return this;
	}

	public ContratoAnalizado region(Region.Category region) {
		bitBuffer.setIntegerNBits(344, 4, region == null ? (int) NULL : region.index);
		return this;
	}

	public ContratoAnalizado poblacion(String poblacion) {
		bitBuffer.setIntegerNBits(348, 7, poblacion == null ? (int) NULL : Poblacion.categoryByName(poblacion).index);
		return this;
	}

	public ContratoAnalizado poblacion(Poblacion.Category poblacion) {
		bitBuffer.setIntegerNBits(348, 7, poblacion == null ? (int) NULL : poblacion.index);
		return this;
	}

	public ContratoAnalizado colonia(String colonia) {
		bitBuffer.setIntegerNBits(355, 17, colonia == null ? (int) NULL : Colonia.categoryByName(colonia).index);
		return this;
	}

	public ContratoAnalizado colonia(Colonia.Category colonia) {
		bitBuffer.setIntegerNBits(355, 17, colonia == null ? (int) NULL : colonia.index);
		return this;
	}

	public ContratoAnalizado ruta(String ruta) {
		bitBuffer.setIntegerNBits(372, 10, ruta == null ? (int) NULL : Ruta.categoryByName(ruta).index);
		return this;
	}

	public ContratoAnalizado ruta(Ruta.Category ruta) {
		bitBuffer.setIntegerNBits(372, 10, ruta == null ? (int) NULL : ruta.index);
		return this;
	}

	public ContratoAnalizado agencia(String agencia) {
		bitBuffer.setIntegerNBits(382, 10, agencia == null ? (int) NULL : Agencia.categoryByName(agencia).index);
		return this;
	}

	public ContratoAnalizado agencia(Agencia.Category agencia) {
		bitBuffer.setIntegerNBits(382, 10, agencia == null ? (int) NULL : agencia.index);
		return this;
	}

	public ContratoAnalizado medioContacto(String medioContacto) {
		bitBuffer.setIntegerNBits(392, 2, medioContacto == null ? (int) NULL : MedioContacto.categoryByName(medioContacto).index);
		return this;
	}

	public ContratoAnalizado medioContacto(MedioContacto.Category medioContacto) {
		bitBuffer.setIntegerNBits(392, 2, medioContacto == null ? (int) NULL : medioContacto.index);
		return this;
	}

	public ContratoAnalizado status(String status) {
		bitBuffer.setIntegerNBits(394, 4, status == null ? (int) NULL : EstatusContrato.categoryByName(status).index);
		return this;
	}

	public ContratoAnalizado status(EstatusContrato.Category status) {
		bitBuffer.setIntegerNBits(394, 4, status == null ? (int) NULL : status.index);
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}