package io.provista.datahub.transaction;

import io.provista.datahub.dimension.*;

public class Consumo extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 20;

	public Consumo() {
		super(defaultByteStore());
	}

	public Consumo(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("rpu", rpu());
		values.put("importe", importe());
		values.put("cantidad", cantidad());
		values.put("tarifa", tarifa());
		values.put("periodo", periodo());
		values.put("clase", clase());
		return values;
	}

	protected long id() {
		return rpu();
	}

	public long rpu() {
		return bitBuffer.getAlignedLong(0);
	}

	public long importe() {
		return bitBuffer.getLongNBits(64, 40);
	}

	public long cantidad() {
		return bitBuffer.getLongNBits(104, 40);
	}

	public Tarifa.Category tarifa() {
		final int value = bitBuffer.getIntegerNBits(144, 8);
		return Tarifa.categoryByIndex(value);
	}

	public ClasePeriodo.Category periodo() {
		final short value = bitBuffer.getShortNBits(152, 3);
		return ClasePeriodo.categoryByIndex(value);
	}

	public ClaseConsumo.Category clase() {
		final short value = bitBuffer.getShortNBits(155, 2);
		return ClaseConsumo.categoryByIndex(value);
	}

	public Consumo rpu(long rpu) {
		bitBuffer.setAlignedLong(0, rpu);
		return this;
	}

	public Consumo importe(long importe) {
		bitBuffer.setLongNBits(64, 40, importe);
		return this;
	}

	public Consumo cantidad(long cantidad) {
		bitBuffer.setLongNBits(104, 40, cantidad);
		return this;
	}

	public Consumo tarifa(String tarifa) {
		bitBuffer.setIntegerNBits(144, 8, tarifa == null ? (int) NULL : Tarifa.categoryByName(tarifa).index);
		return this;
	}

	public Consumo tarifa(Tarifa.Category tarifa) {
		bitBuffer.setIntegerNBits(144, 8, tarifa == null ? (int) NULL : tarifa.index);
		return this;
	}

	public Consumo periodo(String periodo) {
		bitBuffer.setIntegerNBits(152, 3, periodo == null ? (int) NULL : ClasePeriodo.categoryByName(periodo).index);
		return this;
	}

	public Consumo periodo(ClasePeriodo.Category periodo) {
		bitBuffer.setIntegerNBits(152, 3, periodo == null ? (int) NULL : periodo.index);
		return this;
	}

	public Consumo clase(String clase) {
		bitBuffer.setIntegerNBits(155, 2, clase == null ? (int) NULL : ClaseConsumo.categoryByName(clase).index);
		return this;
	}

	public Consumo clase(ClaseConsumo.Category clase) {
		bitBuffer.setIntegerNBits(155, 2, clase == null ? (int) NULL : clase.index);
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}