package io.provista.datahub.transaction;

import io.provista.datahub.dimension.*;

public class Cobro extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 14;

	public Cobro() {
		super(defaultByteStore());
	}

	public Cobro(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("ocr", ocr());
		values.put("importe", importe());
		values.put("canalPago", canalPago());
		values.put("modoPago", modoPago());
		return values;
	}

	protected long id() {
		return ocr();
	}

	public long ocr() {
		return bitBuffer.getAlignedLong(0);
	}

	public long importe() {
		return bitBuffer.getLongNBits(64, 40);
	}

	public CanalPago.Category canalPago() {
		final int value = bitBuffer.getIntegerNBits(104, 4);
		return CanalPago.categoryByIndex(value);
	}

	public ModoPago.Category modoPago() {
		final short value = bitBuffer.getShortNBits(108, 4);
		return ModoPago.categoryByIndex(value);
	}

	public Cobro ocr(long ocr) {
		bitBuffer.setAlignedLong(0, ocr);
		return this;
	}

	public Cobro importe(long importe) {
		bitBuffer.setLongNBits(64, 40, importe);
		return this;
	}

	public Cobro canalPago(String canalPago) {
		bitBuffer.setIntegerNBits(104, 4, canalPago == null ? (int) NULL : CanalPago.categoryByName(canalPago).index);
		return this;
	}

	public Cobro canalPago(CanalPago.Category canalPago) {
		bitBuffer.setIntegerNBits(104, 4, canalPago == null ? (int) NULL : canalPago.index);
		return this;
	}

	public Cobro modoPago(String modoPago) {
		bitBuffer.setIntegerNBits(108, 4, modoPago == null ? (int) NULL : ModoPago.categoryByName(modoPago).index);
		return this;
	}

	public Cobro modoPago(ModoPago.Category modoPago) {
		bitBuffer.setIntegerNBits(108, 4, modoPago == null ? (int) NULL : modoPago.index);
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}