package io.provista.datahub.transaction;

import io.provista.datahub.dimension.*;

public class CarteraSap extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 26;

	public CarteraSap() {
		super(defaultByteStore());
	}

	public CarteraSap(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("saldoAcumulado", saldoAcumulado());
		values.put("saldo", saldo());
		values.put("code", code());
		values.put("zona", zona());
		values.put("cuenta", cuenta());
		return values;
	}

	protected long id() {
		return code();
	}

	public long saldoAcumulado() {
		return bitBuffer.getAlignedLong(0);
	}

	public long saldo() {
		return bitBuffer.getAlignedLong(64);
	}

	public long code() {
		return bitBuffer.getAlignedLong(128);
	}

	public Zona.Category zona() {
		final int value = bitBuffer.getIntegerNBits(192, 8);
		return Zona.categoryByIndex(value);
	}

	public CuentaCartera.Category cuenta() {
		final int value = bitBuffer.getIntegerNBits(200, 5);
		return CuentaCartera.categoryByIndex(value);
	}

	public CarteraSap saldoAcumulado(long saldoAcumulado) {
		bitBuffer.setAlignedLong(0, saldoAcumulado);
		return this;
	}

	public CarteraSap saldo(long saldo) {
		bitBuffer.setAlignedLong(64, saldo);
		return this;
	}

	public CarteraSap code(long code) {
		bitBuffer.setAlignedLong(128, code);
		return this;
	}

	public CarteraSap zona(String zona) {
		bitBuffer.setIntegerNBits(192, 8, zona == null ? (int) NULL : Zona.categoryByName(zona).index);
		return this;
	}

	public CarteraSap zona(Zona.Category zona) {
		bitBuffer.setIntegerNBits(192, 8, zona == null ? (int) NULL : zona.index);
		return this;
	}

	public CarteraSap cuenta(String cuenta) {
		bitBuffer.setIntegerNBits(200, 5, cuenta == null ? (int) NULL : CuentaCartera.categoryByName(cuenta).index);
		return this;
	}

	public CarteraSap cuenta(CuentaCartera.Category cuenta) {
		bitBuffer.setIntegerNBits(200, 5, cuenta == null ? (int) NULL : cuenta.index);
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}