package io.provista.datahub.transaction;

import io.provista.datahub.dimension.*;

public class BajaContrato extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 10;

	public BajaContrato() {
		super(defaultByteStore());
	}

	public BajaContrato(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("rpu", rpu());
		values.put("fechaBaja", fechaBaja());
		return values;
	}

	protected long id() {
		return rpu();
	}

	public long rpu() {
		return bitBuffer.getAlignedLong(0);
	}

	public int fechaBaja() {
		return bitBuffer.getIntegerNBits(64, 16);
	}

	public BajaContrato rpu(long rpu) {
		bitBuffer.setAlignedLong(0, rpu);
		return this;
	}

	public BajaContrato fechaBaja(int fechaBaja) {
		bitBuffer.setIntegerNBits(64, 16, fechaBaja);
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}